/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.TimeLimit;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Blocks;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;
import ru.itmo.ctlab.virgo.sgmwcs.solver.AtomicDouble;
import ru.itmo.ctlab.virgo.sgmwcs.solver.MSTSolver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Postprocessor;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Preprocessor;
import ru.itmo.ctlab.virgo.sgmwcs.solver.RLTSolver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Solver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.TreeSolver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Utils;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Worker;

public class ComponentSolver
implements Solver {
    private final int threshold;
    private TimeLimit tl;
    private Double externLB;
    private boolean isSolvedToOptimality;
    private int logLevel;
    private int threads;
    private boolean cplexOff;
    private double eps;
    private boolean minimize;
    private int preprocessLevel;
    private Graph g;
    private Signals s;
    private int[] preprocessedSize = new int[]{0, 0};

    public int preprocessedNodes() {
        return this.preprocessedSize[0];
    }

    public int preprocessedEdges() {
        return this.preprocessedSize[1];
    }

    public ComponentSolver(int threshold, double eps) {
        this.threshold = threshold;
        this.minimize = eps > 0.0;
        this.eps = eps;
        this.externLB = Double.NEGATIVE_INFINITY;
        this.tl = new TimeLimit(Double.POSITIVE_INFINITY);
        this.threads = 1;
    }

    @Override
    public List<Unit> solve(Graph graph, Signals signals) throws SolverException {
        this.g = graph;
        this.s = signals;
        Graph g = new Graph();
        Signals s = new Signals();
        int vertexBefore = graph.vertexSet().size();
        int edgesBefore = graph.edgeSet().size();
        Utils.copy(graph, signals, g, s);
        HashSet<Unit> units = new HashSet<Unit>(g.vertexSet());
        units.addAll(g.edgeSet());
        long before = System.currentTimeMillis();
        new Preprocessor(g, s, this.threads, this.logLevel).preprocess(this.preprocessLevel);
        this.preprocessedSize[0] = g.vertexSet().size();
        this.preprocessedSize[1] = g.edgeSet().size();
        if (this.logLevel > 0) {
            System.out.print("Preprocessing deleted " + (vertexBefore - g.vertexSet().size()) + " nodes ");
            System.out.println("and " + (edgesBefore - g.edgeSet().size()) + " edges.");
        }
        this.isSolvedToOptimality = false;
        if (g.vertexSet().size() == 0) {
            return null;
        }
        return this.afterPreprocessing(g, new Signals(s, units));
    }

    private List<Unit> afterPreprocessing(Graph graph, Signals signals) throws SolverException {
        long timeBefore = System.currentTimeMillis();
        AtomicDouble lb = new AtomicDouble(this.externLB);
        PriorityQueue<Set<Node>> components = this.getComponents(graph);
        ArrayList<Worker> memorized = new ArrayList<Worker>();
        LinkedBlockingQueue<Runnable> queue2 = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.threads, this.threads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, queue2);
        List<Unit> bestTree = new ArrayList<Unit>();
        while (!components.isEmpty()) {
            Set<Node> component = components.poll();
            Graph subgraph = graph.subgraph(component);
            Node root = null;
            double timeRemains = this.tl.getRemainingTime() - (double)(System.currentTimeMillis() - timeBefore) / 1000.0;
            if (component.size() >= this.threshold && timeRemains > 0.0 && (root = this.getRoot(subgraph, new Blocks(subgraph))) != null) {
                this.addComponents(subgraph, root, components, signals);
            }
            Set<Node> vertexSet = subgraph.vertexSet();
            HashSet<Unit> subset = new HashSet<Unit>(vertexSet);
            subset.addAll(subgraph.edgeSet());
            Signals subSignals = new Signals(signals, subset);
            Node treeRoot = root;
            if (treeRoot == null) {
                treeRoot = vertexSet.stream().max(Comparator.comparing(signals::weight)).orElse(null);
            }
            TreeSolver.Solution mstSol = null;
            if (treeRoot != null) {
                MSTSolver ms = new MSTSolver(subgraph, Solver.makeHeuristicWeights(subgraph, subSignals), treeRoot);
                ms.solve();
                Graph subtree = subgraph.subgraph(vertexSet, ms.getEdges());
                TreeSolver ts = new TreeSolver(subtree, subSignals);
                mstSol = ts.solveRooted(treeRoot);
                double tlb = subSignals.weightSum(mstSol.sets());
                double plb = lb.get();
                if (tlb >= plb) {
                    System.out.println("heuristic found lb " + tlb);
                    lb.compareAndSet(plb, tlb);
                    bestTree = this.extract(new ArrayList<Unit>(mstSol.units));
                }
            }
            if (this.cplexOff) continue;
            RLTSolver solver = new RLTSolver(this.minimize ? 0.0 : 1.0E-9);
            solver.setSharedLB(lb);
            solver.setTimeLimit(this.tl);
            solver.setLogLevel(this.logLevel);
            if (mstSol != null) {
                solver.setInitialSolution(mstSol.units);
            }
            Worker worker = new Worker(subgraph, root, subSignals, solver, timeBefore);
            executor.execute(worker);
            memorized.add(worker);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.cplexOff) {
            return this.getResult(memorized, graph, signals);
        }
        graph.vertexSet().forEach(Unit::clear);
        graph.edgeSet().forEach(Unit::clear);
        return bestTree;
    }

    private List<Unit> getResult(List<Worker> memorized, Graph graph, Signals signals) throws SolverException {
        List<Unit> best = null;
        double bestScore = -1.7976931348623157E308;
        for (Worker worker : memorized) {
            List<Unit> solution = worker.getResult();
            if (!(bestScore < Utils.sum(solution, signals))) continue;
            best = solution;
            bestScore = Utils.sum(solution, signals);
            this.isSolvedToOptimality = worker.isSolvedToOptimality();
        }
        List<Unit> result = this.extract(best);
        graph.vertexSet().forEach(Unit::clear);
        graph.edgeSet().forEach(Unit::clear);
        if (this.minimize && bestScore > 0.0) {
            System.out.println("AFTER PREPROCESSING");
            return new Postprocessor(this.g, this.s, result, this.logLevel).minimize(this.eps);
        }
        return result;
    }

    private Node getRoot(Graph graph, Blocks blocks) {
        HashMap<Node, Integer> maximum = new HashMap<Node, Integer>();
        if (blocks.cutpoints().isEmpty()) {
            return null;
        }
        Node v = blocks.cutpoints().iterator().next();
        this.dfs(v, null, blocks, maximum, graph.vertexSet().size());
        if (maximum.isEmpty()) {
            return null;
        }
        Node best = (Node)maximum.keySet().iterator().next();
        for (Node u : maximum.keySet()) {
            if ((Integer)maximum.get(u) >= (Integer)maximum.get(best)) continue;
            best = u;
        }
        return best;
    }

    private int dfs(Node v, Node p, Blocks blocks, Map<Node, Integer> max, int n) {
        int res = 0;
        for (Set<Node> c : blocks.incidentBlocks(v)) {
            if (c.contains(p)) continue;
            int sum = c.size() - 1;
            for (Node cp : blocks.cutpointsOf(c)) {
                if (cp == v) continue;
                sum += this.dfs(cp, v, blocks, max, n);
            }
            if (!max.containsKey(v) || max.get(v) < sum) {
                max.put(v, sum);
            }
            res += sum;
        }
        int rest = n - res - 1;
        if (!max.containsKey(v) || max.get(v) < rest) {
            max.put(v, rest);
        }
        return res;
    }

    private List<Unit> extract(List<Unit> s) {
        if (s == null) {
            return null;
        }
        ArrayList<Unit> l = new ArrayList<Unit>(s);
        for (Unit u : s) {
            l.addAll(u.getAbsorbed());
        }
        return l;
    }

    @Override
    public boolean isSolvedToOptimality() {
        return this.isSolvedToOptimality;
    }

    private void addComponents(Graph graph, Node root, PriorityQueue<Set<Node>> components, Signals signals) throws SolverException {
        graph = graph.subgraph(graph.vertexSet());
        graph.removeVertex(root);
        components.addAll(graph.connectedSets());
    }

    private PriorityQueue<Set<Node>> getComponents(Graph graph) {
        PriorityQueue<Set<Node>> result = new PriorityQueue<Set<Node>>(new SetComparator());
        result.addAll(graph.connectedSets());
        return result;
    }

    @Override
    public TimeLimit getTimeLimit() {
        return this.tl;
    }

    @Override
    public void setTimeLimit(TimeLimit tl) {
        this.tl = tl;
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setThreadsNum(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.threads = n;
    }

    @Override
    public void setLB(double lb) {
        this.externLB = lb;
    }

    @Override
    public double getLB() {
        return this.externLB;
    }

    public void setPreprocessingLevel(int preprocessLevel) {
        this.preprocessLevel = preprocessLevel;
    }

    public void setCplexOff(boolean cplexOff) {
        this.cplexOff = cplexOff;
    }

    public static class SetComparator
    implements Comparator<Set<Node>> {
        @Override
        public int compare(Set<Node> o1, Set<Node> o2) {
            return -Integer.compare(o1.size(), o2.size());
        }
    }
}

