\name{rmvSE}

\alias{rmvSE}

\title{Random generation from a SE distribution.}

\description{This function generates draws from a p-variate Skew-Elliptical distribution.}

\usage{rmvSE(n, p, X=NULL, modelType, theta)}

\arguments{
 \item{n}{number of draws.}
 \item{p}{dimension of the drawn vectors.}
 \item{X}{a design matrix.}
 \item{modelType}{generating distribution. Already implemented modelTypes are 'N' (Normal), 'SN' (skew-normal), 'T' (Student T), and 'ST' (skew-t).}
 \item{theta}{list of parameters. The list should contain elements named 'xi' (numeric), 'G' (pxp matrix), 'psi' (numeric, optional) and 'nu' (scalar, optional).}
}

\value{A list with three elements
 \itemize{
  \item{\code{y}}{ n x p matrix of the random draws from a p-variate SE distribution.}
  \item{\code{z}}{ vector of the latent values z (NULL for symmetric models)}
  \item{\code{v}}{ vector of the latent values v (NULL for the N and SN models)}
 }
}

\references{Azzalini, A. and Capitanio, A. (2003) "Distributions generated by perturbation of symmetry with emphasis on a multivariate skew t distribution", \emph{JRSSB} (see eq. 25).}

\seealso{\code{\link{cmlSE}}, \code{\link{mcSE}}.}

\examples{
## Generate artificial data
pars = list(xi=c(3,5), psi=c(2,4), G=diag(2), nu=6)
values = rmvSE(n=200, p=2, modelType='ST', theta=pars)
## X contains the data matrix and the vectors z and v of latent variables:
y = values$y
z = values$z
v = values$v
}
