% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{glm.nb_mverse}
\alias{glm.nb_mverse}
\title{Fit negative binomial regression models across the multiverse}
\usage{
glm.nb_mverse(.mverse)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}
}
\value{
A \code{mverse} object with \code{glm.nb} fitted.
}
\description{
\code{glm.nb_mverse} fits \code{MASS::glm.nb} across the multiverse
according to model specifications provided by \code{formula_branch}.
At least one \code{formula_branch} must have been added.
}
\examples{
\donttest{

# Fitting \code{glm.nb} models across a multiverse.
hurricane_strength <- mutate_branch(
  NDAM,
  HighestWindSpeed,
  Minpressure_Updated_2014
)
hurricane_outliers <- filter_branch(
  !Name \%in\% c("Katrina", "Audrey", "Andrew"),
  TRUE # include all
)
model_specifications <- formula_branch(
  alldeaths ~ femininity,
  alldeaths ~ femininity + hurricane_strength
)
mv <- create_multiverse(hurricane) \%>\%
  add_filter_branch(hurricane_outliers) \%>\%
  add_mutate_branch(hurricane_strength) \%>\%
  add_formula_branch(model_specifications) \%>\%
  glm.nb_mverse()
}
}
\seealso{
Other model fitting functions: 
\code{\link{glm_mverse}()},
\code{\link{lm_mverse}()}
}
\concept{model fitting functions}
