/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.wizard;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.spi.wizard.SimpleWizard;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardBranchController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardImplementation;
import org.netbeans.spi.wizard.WizardObserver;

final class BranchingWizard
implements WizardImplementation {
    private final List listenerList = Collections.synchronizedList(new LinkedList());
    private final WizardBranchController brancher;
    final WizardImplementation initialSteps;
    private WizardImplementation subsequentSteps;
    private WizardImplementation activeWizard;
    private WL wl;
    private String currStep;
    private Map wizardData;

    public BranchingWizard(WizardBranchController brancher) {
        this.brancher = brancher;
        this.initialSteps = new SimpleWizard(brancher.getBase(), true);
        this.setCurrent(this.initialSteps);
    }

    protected final WizardImplementation createSecondary(Map settings) {
        Wizard wiz = this.brancher.getWizardForStep(this.currStep, settings);
        return wiz == null ? null : wiz.impl;
    }

    private void checkForSecondary() {
        if (this.wizardData == null) {
            return;
        }
        WizardImplementation newSecondary = this.createSecondary(this.wizardData);
        if (this.activeWizard instanceof BranchingWizard) {
            ((BranchingWizard)this.activeWizard).setSecondary(newSecondary);
        } else {
            this.setSecondary(newSecondary);
        }
    }

    private void setSecondary(WizardImplementation newSecondary) {
        if ((this.subsequentSteps == null != (newSecondary == null) || this.subsequentSteps != null && !this.subsequentSteps.equals(newSecondary)) && !this.equals(newSecondary) && Arrays.asList(this.initialSteps.getAllSteps()).contains(this.currStep)) {
            this.subsequentSteps = newSecondary;
            this.fireStepsChanged();
        }
    }

    public int getForwardNavigationMode() {
        return this.activeWizard.getForwardNavigationMode();
    }

    private void setCurrent(WizardImplementation wizard) {
        if (this.activeWizard == wizard) {
            return;
        }
        if (wizard == null) {
            throw new NullPointerException("Can't set current wizard to null");
        }
        if (this.activeWizard != null && this.wl != null) {
            this.activeWizard.removeWizardObserver(this.wl);
        }
        this.activeWizard = wizard;
        if (this.wl == null) {
            this.wl = new WL();
        }
        this.activeWizard.addWizardObserver(this.wl);
    }

    public final boolean isBusy() {
        return this.activeWizard.isBusy();
    }

    public final Object finish(Map settings) throws WizardException {
        WizardException exc = null;
        try {
            Object result = this.activeWizard.finish(settings);
            this.initialSteps.removeWizardObserver(this.wl);
            if (this.subsequentSteps != null) {
                this.subsequentSteps.removeWizardObserver(this.wl);
            }
            Object object = result;
            Object var6_6 = null;
            if (exc == null) {
                this.subsequentSteps = null;
            }
            return object;
        }
        catch (WizardException we) {
            try {
                exc = we;
                if (we.getStepToReturnTo() != null) {
                    this.initialSteps.addWizardObserver(this.wl);
                    if (this.subsequentSteps != null) {
                        this.subsequentSteps.addWizardObserver(this.wl);
                    }
                }
                throw we;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var6_7 = null;
                    if (exc != null) break block8;
                    this.subsequentSteps = null;
                }
                throw throwable;
            }
        }
    }

    public final String[] getAllSteps() {
        String[] result;
        if (this.subsequentSteps == null) {
            String[] bsteps = this.initialSteps.getAllSteps();
            result = new String[bsteps.length + 1];
            System.arraycopy(bsteps, 0, result, 0, bsteps.length);
            result[result.length - 1] = "_#UndeterminedStep";
        } else {
            String[] bsteps = this.initialSteps.getAllSteps();
            String[] csteps = this.subsequentSteps.getAllSteps();
            result = new String[bsteps.length + csteps.length];
            System.arraycopy(bsteps, 0, result, 0, bsteps.length);
            System.arraycopy(csteps, 0, result, bsteps.length, csteps.length);
        }
        return result;
    }

    public String getCurrentStep() {
        return this.currStep;
    }

    public final String getNextStep() {
        String result;
        if (this.currStep == null) {
            result = this.getAllSteps()[0];
        } else {
            String[] steps = this.getAllSteps();
            int idx = Arrays.asList(steps).indexOf(this.currStep);
            if (idx == -1) {
                throw new IllegalStateException("Current step not in available steps:  " + this.currStep + " not in " + Arrays.asList(steps));
            }
            if (idx == steps.length - 1) {
                result = this.subsequentSteps == null ? "_#UndeterminedStep" : this.subsequentSteps.getNextStep();
            } else {
                WizardImplementation w = this.ownerOf(this.currStep);
                if (w == this.initialSteps && idx == this.initialSteps.getAllSteps().length - 1) {
                    this.checkForSecondary();
                    result = this.subsequentSteps != null ? this.subsequentSteps.getAllSteps()[0] : "_#UndeterminedStep";
                } else {
                    result = w.getNextStep();
                }
            }
        }
        return this.getProblem() == null ? result : ("_#UndeterminedStep".equals(result) ? result : null);
    }

    public final String getPreviousStep() {
        if (this.activeWizard == this.subsequentSteps && this.subsequentSteps.getAllSteps()[0].equals(this.currStep)) {
            return this.initialSteps.getAllSteps()[this.initialSteps.getAllSteps().length - 1];
        }
        return this.activeWizard.getPreviousStep();
    }

    public final String getProblem() {
        return this.activeWizard.getProblem();
    }

    public final String getStepDescription(String id) {
        WizardImplementation w = this.ownerOf(id);
        if (w == null) {
            return null;
        }
        return w.getStepDescription(id);
    }

    public final String getLongDescription(String id) {
        WizardImplementation w = this.ownerOf(id);
        if (w == null) {
            return null;
        }
        return w.getLongDescription(id);
    }

    private WizardImplementation ownerOf(String id) {
        if ("_#UndeterminedStep".equals(id)) {
            this.checkForSecondary();
            return this.subsequentSteps;
        }
        if (Arrays.asList(this.initialSteps.getAllSteps()).contains(id)) {
            return this.initialSteps;
        }
        if (this.subsequentSteps != null) {
            if (!Arrays.asList(this.subsequentSteps.getAllSteps()).contains(id)) {
                this.checkForSecondary();
            }
        } else {
            this.checkForSecondary();
        }
        return this.subsequentSteps;
    }

    public final String getTitle() {
        return this.activeWizard.getTitle();
    }

    public final JComponent navigatingTo(String id, Map settings) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.currStep = id;
        this.wizardData = settings;
        WizardImplementation impl = this.ownerOf(id);
        if (impl == null) {
            throw new NullPointerException("No owning WizardImplementation for id " + id);
        }
        this.setCurrent(impl);
        return this.activeWizard.navigatingTo(id, settings);
    }

    public final void removeWizardObserver(WizardObserver observer) {
        this.listenerList.remove(observer);
    }

    public final void addWizardObserver(WizardObserver observer) {
        this.listenerList.add(observer);
    }

    private void fireStepsChanged() {
        WizardObserver[] listeners = this.listenerList.toArray(new WizardObserver[0]);
        for (int i = listeners.length - 1; i >= 0; --i) {
            WizardObserver l = listeners[i];
            l.stepsChanged(null);
        }
    }

    private void fireNavigabilityChanged() {
        this.checkForSecondary();
        WizardObserver[] listeners = this.listenerList.toArray(new WizardObserver[0]);
        for (int i = listeners.length - 1; i >= 0; --i) {
            WizardObserver l = listeners[i];
            l.navigabilityChanged(null);
        }
    }

    private void fireSelectionChanged() {
        WizardObserver[] listeners = this.listenerList.toArray(new WizardObserver[0]);
        for (int i = listeners.length - 1; i >= 0; --i) {
            WizardObserver l = listeners[i];
            l.selectionChanged(null);
        }
    }

    public boolean cancel(Map settings) {
        return this.activeWizard == null ? true : this.activeWizard.cancel(settings);
    }

    private class WL
    implements WizardObserver {
        private WL() {
        }

        public void stepsChanged(Wizard wizard) {
            BranchingWizard.this.fireStepsChanged();
        }

        public void navigabilityChanged(Wizard wizard) {
            BranchingWizard.this.fireNavigabilityChanged();
        }

        public void selectionChanged(Wizard wizard) {
            BranchingWizard.this.fireSelectionChanged();
        }
    }
}

