% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpmultinom.R
\name{rpbinom}
\alias{rpbinom}
\alias{rpmultinom}
\title{Random Generation for Independent Multinomial Distributions}
\usage{
rpbinom(prob, n)

rpmultinom(prob, n, options, drop_fixed = TRUE)
}
\arguments{
\item{prob}{vector with probabilities or a matrix with one probability vector per row.
For \code{rpbinom}: probabilities of a success for each option.
For \code{rpmultinom}: probabilities of all categories excluding
the last category for each option (cf. \code{drop_fixed}).
See also \code{\link{sampling_binom}} and \code{\link{sampling_multinom}}.}

\item{n}{integer vector, specifying the number of trials for each binomial/multinomial distribution
Note that this is the \code{size} argument in \code{rmultinom}, cf. \code{\link[stats]{Multinom}}.}

\item{options}{number of observable categories/probabilities for each item
type/multinomial distribution, e.g., \code{c(3,2)} for a ternary and binary item.}

\item{drop_fixed}{whether the output matrix includes the last probability for each category
(which is not a free parameter since probabilities must sum to one).}
}
\value{
a matrix with one vector of frequencies per row. For \code{rpbinom}, only
   the frequencies of 'successes' are returned, whereas for \code{rpmultinom}, the
   complete frequency vectors (which sum to \code{n} within each option) are returned.
}
\description{
Generates random draws from independent multinomial distributions (= product-multinomial \code{pmultinom}).
}
\examples{
# 3 binomials
rpbinom(prob = c(.2, .7, .9), n = c(10, 50, 30))

# 2 and 3 options:  [a1,a2,  b1,b2,b3]
rpmultinom(
  prob = c(a1 = .5, b1 = .3, b2 = .6),
  n = c(10, 20), options = c(2, 3)
)
# or:
rpmultinom(
  prob = c(a1 = .5, a2 = .5, b1 = .3, b2 = .6, b3 = .1),
  n = c(10, 20), options = c(2, 3),
  drop_fixed = FALSE
)

# matrix with one probability vector per row:
p <- rpdirichlet(
  n = 6, alpha = c(1, 1, 1, 1, 1),
  options = c(2, 3)
)
rpmultinom(prob = p, n = c(20, 50), options = c(2, 3))
}
