% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_bf.R
\name{population_bf}
\alias{population_bf}
\title{Aggregation of Individual Bayes Factors}
\usage{
population_bf(bfs)
}
\arguments{
\item{bfs}{a vector with individual Bayes factors,
a matrix with one type of Bayes-factor comparison per column,
or a list of matrices with a named column \code{"bf"} (as returned by
\code{\link{bf_multinom}}/\code{\link{count_to_bf}}).}
}
\value{
a vector or matrix with named elements/columns:
   \itemize{
     \item \code{population_bf}: the product of individual BFs
     \item \code{geometric_bf}: the geometric mean of the individual BFs
     \item \code{evidence_rate}: the proportion of BFs>1 (BFs<1) if \code{geometric_bf>1} (<1).
         Values close to 1.00 indicate homogeneity.
     \item \code{stability_rate}: the proportion \code{bfs>geometric_bf} (<) if \code{geometric_bf>1} (<).
         Values close to 0.50 indicate stability.
   }
}
\description{
Aggregation of multiple individual (N=1) Bayes factors to obtain the evidence
for a hypothesis in a population of persons.
}
\examples{
# consistent evidence across persons:
bfs <- c(2.3, 1.8, 3.3, 2.8, 4.0, 1.9, 2.5)
population_bf(bfs)

# (A) heterogeneous, inconsistent evidence
# (B) heterogeneous, inconsistent evidence
bfs <- cbind(
  A = c(2.3, 1.8, 3.3, 2.8, 4.0, 1.9, 2.5),
  B = c(10.3, .7, 3.3, .8, 14.0, .9, 1.5)
)
population_bf(bfs)

}
\references{
Klaassen, F., Zedelius, C. M., Veling, H., Aarts, H., & Hoijtink, H. (in press).
All for one or some for all? Evaluating informative hypotheses using multiple N = 1 studies.
Behavior Research Methods. https://doi.org/10.3758/s13428-017-0992-5
}
