% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nirt.R
\name{nirt_to_Ab}
\alias{nirt_to_Ab}
\title{Nonparametric Item Response Theory (NIRT)}
\usage{
nirt_to_Ab(N, M, options = 2, axioms = c("W1", "W2"))
}
\arguments{
\item{N}{number of persons / rows in item-response table}

\item{M}{number of items / columns in item-response table}

\item{options}{number of item categories/response options. If \code{options=2},
a dichotomous NIRT for product-binomial data is returned.}

\item{axioms}{which axioms should be included in the polytope representation \eqn{A*x <= b}?
See details.}
}
\description{
Provides the inequality constraints on choice probabilities implied by
nonparametric item response theory (NIRT; Karabatsos, 2001).
}
\details{
In contrast to parametric IRT models (e.g., the 1-parameter-logistic Rasch model),
NIRT does not assume specific parametric shapes of the item-response and person-response
functions. Instead, the necessary axioms for a unidimensional representation of
the latent trait are tested directly.

The axioms are as follows:
\itemize{
  \item{\code{"W1"}: }{Weak row/subject independence: Persons can be ordered on
                      an ordinal scale independent of items.}
  \item{\code{"W2"}: }{Weak column/item independence: Items can be ordered on
                      an ordinal scale independent of persons}
  \item{\code{"DC"}: }{Double cancellation: A necessary condition for a joint
                     ordering of (person,item) pairs and an additive representation
                     (i.e., an interval scale).}
}

Note that axioms W1 and W2 jointly define the ISOP model by Scheiblechner
(1995; isotonic ordinal probabilistic model) and the double homogeneity model
by Mokken (1971). If DC is added, we obtain the ADISOP model
by Scheiblechner (1999; ).
}
\examples{
# 5 persons, 3 items
nirt_to_Ab(5, 3)
}
\references{
Karabatsos, G. (2001). The Rasch model, additive conjoint measurement, and new models of probabilistic measurement theory. Journal of Applied Measurement, 2(4), 389â€“423.

Karabatsos, G., & Sheu, C.-F. (2004). Order-constrained Bayes inference for dichotomous models of unidimensional nonparametric IRT. Applied Psychological Measurement, 28(2), 110-125. \doi{10.1177/0146621603260678}

Mokken, R. J. (1971). A theory and procedure of scale analysis: With applications in political research (Vol. 1). Berlin: Walter de Gruyter.

Scheiblechner, H. (1995). Isotonic ordinal probabilistic models (ISOP).
Psychometrika, 60(2), 281â€“304. \doi{10.1007/BF02301417}

Scheiblechner, H. (1999). Additive conjoint isotonic probabilistic models (ADISOP).
Psychometrika, 64(3), 295â€“316. \doi{10.1007/BF02294297}
}
