% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinomineq_package.R
\docType{package}
\name{multinomineq-package}
\alias{multinomineq}
\alias{multinomineq-package}
\title{multinomineq: Bayesian Inference for Inequality-Constrained Multinomial Models}
\description{
{
\if{html}{\figure{multinomineq.png}{options: width=120 alt ="multinomineq" align="right" hspace="20"}}
\if{latex}{\figure{multinomineq.png}{options: width=0.5in}}

Implements Gibbs sampling and Bayes factors for multinomial models with
convex, linear-inequality constraints on the probability parameters. This
includes models that predict a linear order of binomial probabilities
(e.g., p1 < p2 < p3 < .50) and mixture models, which assume that the
parameter vector p must be inside the convex hull of a finite number of
vertices.
}
}
\details{
A formal definition of inequality-constrained multinomial models and the
implemented computational methods for Bayesian inference is provided in:
\itemize{
\item Heck, D. W., & Davis-Stober, C. P. (2019).
  Multinomial models with linear inequality constraints:
  Overview and improvements of computational methods for Bayesian inference.
  Manuscript under revision. \url{https://arxiv.org/abs/1808.07140}
}

Inequality-constrained multinomial models have applications in multiple areas
in psychology, judgement and decision making, and beyond:
\itemize{
 \item Testing choice axioms such as transitivity and random utility theory
       (Regenwetter et al., 2012, 2014). See \code{\link{regenwetter2012}}
 \item Testing deterministic axioms of measurement and choice (Karabatsos, 2005; Myung et al., 2005).
 \item Multiattribute decisions for probabilistic inferences involving strategies such as
       Take-the-best (TTB) vs. weighted additive (WADD; Bröder & Schiffer, 2003; Heck et al., 2017)
       See \code{\link{heck2017}} and \code{\link{hilbig2014}}
 \item Fitting and testing nonparametric item response theory models (Karabatsos & Sheu, 2004).
       See \code{\link{karabatsos2004}}
 \item Statistical inference for order-constrained contingency tables (Klugkist et al., 2007, 2010).
       See \code{\link{bf_nonlinear}}
 \item Testing stochastic dominance of response time distributions (Heathcote et al., 2010).
       See \code{\link{stochdom_bf}}
 \item Cognitive diagnostic assessment (Hoijtink et al., 2014).
}

For convex polytopes, the transformation of vertex to inequality representation
requires the R package \code{rPorta} available at \url{https://github.com/TasCL/rPorta}
}
\references{
Bröder, A., & Schiffer, S. (2003). Bayesian strategy assessment in multi-attribute decision making. Journal of Behavioral Decision Making, 16(3), 193-213. \url{https://doi.org/10.1002/bdm.442}

Bröder, A., & Schiffer, S. (2003). Take The Best versus simultaneous feature matching: Probabilistic inferences from memory and effects of reprensentation format. Journal of Experimental Psychology: General, 132, 277-293. \url{https://doi.org/10.1037/0096-3445.132.2.277}

Heck, D. W., Hilbig, B. E., & Moshagen, M. (2017). From information processing to decisions: Formalizing and comparing probabilistic choice models. Cognitive Psychology, 96, 26-40. \url{https://doi.org/10.1016/j.cogpsych.2017.05.003}

Hilbig, B. E., & Moshagen, M. (2014). Generalized outcome-based strategy classification: Comparing deterministic and probabilistic choice models. Psychonomic Bulletin & Review, 21(6), 1431-1443. \url{https://doi.org/10.3758/s13423-014-0643-0}

Regenwetter, M., & Davis-Stober, C. P. (2012). Behavioral variability of choices versus structural inconsistency of preferences. Psychological Review, 119(2), 408-416. \url{https://doi.org/10.1037/a0027372}

Regenwetter, M., Davis-Stober, C. P., Lim, S. H., Guo, Y., Popova, A., Zwilling, C., … Messner, W. (2014). QTest: Quantitative testing of theories of binary choice. Decision, 1(1), 2-34. \url{https://doi.org/10.1037/dec0000007}

Karabatsos, G. (2005). The exchangeable multinomial model as an approach to testing deterministic axioms of choice and measurement. Journal of Mathematical Psychology, 49(1), 51-69. \url{https://doi.org/10.1016/j.jmp.2004.11.001}

Myung, J. I., Karabatsos, G., & Iverson, G. J. (2005). A Bayesian approach to testing decision making axioms. \emph{Journal of Mathematical Psychology, 49}, 205-225. \url{https://doi.org/10.1016/j.jmp.2005.02.004}

Karabatsos, G., & Sheu, C.-F. (2004). Order-constrained Bayes inference for dichotomous models of unidimensional nonparametric IRT. Applied Psychological Measurement, 28(2), 110-125. \url{https://doi.org/10.1177/0146621603260678}

Hoijtink, H. (2011). Informative Hypotheses: Theory and Practice for Behavioral and Social Scientists. Boca Raton, FL: Chapman & Hall/CRC.

Hoijtink, H., Béland, S., & Vermeulen, J. A. (2014). Cognitive diagnostic assessment via Bayesian evaluation of informative diagnostic hypotheses. Psychological Methods, 19(1), 21–38. doi:10.1037/a0034176

Klugkist, I., & Hoijtink, H. (2007). The Bayes factor for inequality and about equality constrained models. Computational Statistics & Data Analysis, 51(12), 6367-6379. \url{https://doi.org/10.1016/j.csda.2007.01.024}

Klugkist, I., Laudy, O., & Hoijtink, H. (2010). Bayesian evaluation of inequality and equality constrained hypotheses for contingency tables. Psychological Methods, 15(3), 281-299. \url{https://doi.org/10.1037/a0020137}

Heathcote, A., Brown, S., Wagenmakers, E. J., & Eidels, A. (2010). Distribution-free tests of stochastic dominance for small samples. Journal of Mathematical Psychology, 54(5), 454-463. \url{https://doi.org/10.1016/j.jmp.2010.06.005}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/danheck/multinomineq}
}

}
\author{
Daniel W. Heck
}
