% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot-coord.R
\name{pivot_coord_refit}
\alias{pivot_coord_refit}
\title{Estimate pivot balance coordinates by refitting model.}
\usage{
pivot_coord_refit(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{...}{Further arguments passed to \code{\link[brms:brm]{brm}}.}
}
\value{
A list of \code{\link{brmcoda}} for each pivot balance coordinate.
}
\description{
Estimate pivot balance coordinates by refitting model.
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  cilr <- complr(data = mcompd, sbp = sbp,
                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID",
                 total = 1440)
  
  m <- brmcoda(complr = cilr,
                formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
                                   wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
                chain = 1, iter = 500,
                backend = "cmdstanr")
  
  m_pivot_coord_refit <- pivot_coord_refit(m)
  summary(m_pivot_coord_refit)
  }}
}
