% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.substitution}
\alias{summary.substitution}
\title{Create a Summary of a Substitution Model represented by a \code{substitution} object}
\usage{
\method{summary}{substitution}(object, delta, to, from, ref, level, digits = 2, ...)
}
\arguments{
\item{object}{A \code{substitution} class object.}

\item{delta}{A integer, numeric value or vector indicating the desired \code{delta}
at which substitution results should be summarised.
Default to all \code{delta} available in the \code{substitution} object.}

\item{to}{A character value or vector specifying the names of the compositional parts
that were reallocated to in the model.}

\item{from}{A character value or vector specifying the names of the compositional parts
that were reallocated from in the model.}

\item{ref}{Either a character value or vector ((\code{"grandmean"} and/or \code{"clustermean"} or \code{"users"}),
Default to all \code{ref} available in the \code{substitution} object.}

\item{level}{A character string or vector (\code{"between"} and/or \code{"within"}).
Default to all \code{level} available in the \code{substitution} object.}

\item{digits}{A integer value used for number formatting. Default is \code{2}.}

\item{...}{generic argument, not in use.}
}
\value{
A summary of \code{substitution} object.
\itemize{
\item{\code{Mean}}{ Posterior means.}
\item{\code{CI_low} and \code{CI_high}}{ 95\% credible intervals.}
\item{\code{Delta}}{ Amount substituted across compositional parts.}
\item{\code{From}}{ Compositional part that is substituted from.}
\item{\code{To}}{ Compositional parts that is substituted to.}
\item{\code{Level}}{ Level where changes in composition takes place. Either \code{between} or \code{within}.}
\item{\code{Reference}}{ Either \code{grandmean}, \code{clustermean}, or \code{users}.}
}
}
\description{
Create a Summary of a Substitution Model represented by a \code{substitution} object
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  ## fit a model with compositional predictor at between and between-person levels
  m <- brmcoda(compilr = compilr(data = mcompd, sbp = sbp,
                                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                                 idvar = "ID", total = 1440),
  formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
    wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
  chain = 1, iter = 500,
  backend = "cmdstanr")
  
  subm <- substitution(object = m, delta = 5)
  summary(subm)
}}
}
