% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{meanDecompose}
\alias{meanDecompose}
\title{Mean decomposition of a variable by group(s)}
\usage{
meanDecompose(formula, data)
}
\arguments{
\item{formula}{A formula of the variables to be used in the analysis.
Should have the form: variable ~ groupingfactors.}

\item{data}{A data table or data frame containing the variables
used in the formula.  This is a required argument.}
}
\value{
A list of data tables with the means or residuals
}
\description{
This function decomposes a variable in a long data set by grouping
factors, such as by ID. If multiple grouping factors are listed,
the decomposition is in order from left to right.
Residuals from the lowest level are returned.
}
\examples{
meanDecompose(mpg ~ vs, data = mtcars)
meanDecompose(mpg ~ vs + cyl, data = mtcars)

## Example plotting the results
tmp <- meanDecompose(Sepal.Length ~ Species, data = iris)
do.call(ggpubr::ggarrange, c(lapply(names(tmp), function(x) {
  plot(JWileymisc::testDistribution(tmp[[x]]$X), plot = FALSE, varlab = x)$Density
}), ncol = 1))

rm(tmp)
}
\keyword{multivariate}
