% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_S3methods.R
\name{plot.summary.bmult}
\alias{plot.summary.bmult}
\title{Plot estimates}
\usage{
\method{plot}{summary.bmult}(
  x,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  panel.first = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{summary.bmult}-object returned by \code{summary()}.}

\item{main}{\code{character}. A string used as title. Defaults to the informed
hypothesis and the Bayes factor.}

\item{xlab}{\code{character}. A string used as title for the x-axis.}

\item{ylab}{\code{character}. A string used as title for the y-axis.}

\item{xlim}{numeric vectors of length 2, giving the x and y
    coordinates ranges.}

\item{ylim}{numeric vectors of length 2, giving the x and y
    coordinates ranges.}

\item{panel.first}{\code{expression}. Evaluated after the plot axes are set up but
before any plotting takes place. This can be useful for drawing background
grids or null distributions.}

\item{...}{additional arguments passed to \code{plot.summary.bmult}-method.}
}
\value{
Invisibly returns a \code{data.frame} with the plotted estimates.
}
\description{
Plots the posterior estimates from the unconstrained multi- or binomial model.
}
\examples{
# data
x <- c(3, 4, 10, 11, 7, 30)
# priors
a <- c(1, 1, 1, 1, 1, 1)
# restricted hypothesis
factor_levels <- c('theta1', 'theta2', 'theta3', 'theta4', 'theta5', 
                   'theta6')
Hr <- c('theta1', '<',  'theta2', '&', 'theta3', '=', 
'theta4', ',', 'theta5', '<', 'theta6')
output_total  <- mult_bf_informed(x, Hr, a, factor_levels, seed=2020, 
niter=1e3, bf_type = "BFer")
plot(summary(output_total))

# data for a big Bayes factor
x <- c(3, 4, 10, 11, 7, 30) * 1000
output_total  <- mult_bf_informed(x, Hr, a, factor_levels, seed=2020, 
niter=1e3, bf_type = "BFre")
plot(summary(output_total))
}
