% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pn_lognormalDensity.R
\docType{class}
\name{Pn_lognormalDensity-class}
\alias{Pn_lognormalDensity-class}
\alias{Pn_lognormalDensity}
\title{An S4 class to represent the function \eqn{\frac{1}{(\prod_{i=1}^{n}x_i) \sqrt{(2\pi)^n\det(\Sigma)}}\exp(-((\ln(\vec{x})-\vec{\mu})^{T}\Sigma^{-1}(\ln(\vec{x})-\vec{\mu}))/2)} on \eqn{[0,\infty)^n}}
\description{
Implementation of the function
\deqn{f \colon R^n \to [0,\infty),\, \vec{x} \mapsto f(\vec{x}) = \frac{1}{(\prod_{i=1}^{n}x_i) \sqrt{(2\pi)^n\det(\Sigma)}}\exp(-((\ln(\vec{x})-\vec{\mu})^{T}\Sigma^{-1}(\ln(\vec{x})-\vec{\mu}))/2),}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{[0,\infty)^n = \times_{i=1}^n [0,\infty)}.
In this case the integral is know to be
\deqn{\int_{R^n} f(\vec{x}) d\vec{x} = 1.}
}
\details{
The instance needs to be created with three parameters representing the dimension \eqn{n}, the location vector \eqn{\vec{\mu}} and the variance-covariance matrix \eqn{\Sigma} which needs to be symmetric positive definite.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{mean}}{A vector of size dim with real entries.}

\item{\code{sigma}}{A matrix of size dim x dim that is symmetric positive definite.}
}}

\examples{
n <- as.integer(3)
f <- new("Pn_lognormalDensity",dim=n,mean=rep(0,n),sigma=diag(n))
}
\author{
Klaus Herrmann
}
