% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtar.R
\name{forecasting}
\alias{forecasting}
\title{Forecasting of a multivariate TAR model.}
\usage{
forecasting(object, data, out.of.sample = FALSE, credible = 0.95, row.names)
}
\arguments{
\item{object}{an object of the class \emph{mtar}.}

\item{data}{an (optional) data frame, list or environment (or object coercible by
\link{as.data.frame} to a data frame) containing the future values of the threshold
series as well as the exogenous series in the model.
If not found in data, the variables are taken from \code{environment(formula)},
typically the environment from which \code{mtar} is called.}

\item{out.of.sample}{an (optional) logical variable. If \code{TRUE}, then the log-score is computed, which is a measurement to assess density forecasts. Therefore, the data.frame specified in the argument \code{data} must to include the true values of the output series.}

\item{credible}{an (optional) value for the level of the credible intervals. By default, \code{credible} is set to 0.95.}

\item{row.names}{an vector that allows the user to name the time point to
which each row in the data set \code{data} corresponds.}
}
\value{
a list with the following component
\tabular{ll}{
\code{ypred}   \tab a matrix with the results of the forecasting,\cr
\tab \cr
\code{summary} \tab a matrix with the mean and credible intervals of the forecasting,\cr
}
}
\description{
This function computes forecasting from a fitted multivariate TAR model.
}
\examples{
\donttest{
###### Example 1: Returns of the closing prices of three financial indexes
data(returns)
fit1 <- mtar(~ COLCAP + BOVESPA | SP500, data=returns, row.names=Date,
             dist="Gaussian", ars=list(p=c(1,1,2)), n.burnin=100,
             n.sim=3000, n.thin=2)
out1 <- forecasting(fit1,data=subset(returns,Date >= "2016-03-20"),row.names=Date)
out1$summary

###### Example 2: Rainfall and two river flows in Colombia
data(riverflows)
fit2 <- mtar(~ Bedon + LaPlata | Rainfall, data=riverflows, row.names=Date,
             dist="Gaussian", ars=list(p=c(5,5,5)), n.burnin=2000,
             n.sim=3000, n.thin=2)
out2 <- forecasting(fit2,data=subset(riverflows,Date >= "2009-04-09"),row.names=Date)
out2$summary
}

}
\references{
Nieto, F.H. (2005) Modeling Bivariate Threshold Autoregressive Processes in the Presence of Missing Data.
            Communications in Statistics - Theory and Methods, 34, 905-930.

Romero, L.V. and Calderon, S.A. (2021) Bayesian estimation of a multivariate TAR model when the noise
            process follows a Student-t distribution. Communications in Statistics - Theory and Methods, 50, 2508-2530.

Calderon, S.A. and Nieto, F.H. (2017) Bayesian analysis of multivariate threshold autoregressive models
            with missing data. Communications in Statistics - Theory and Methods, 46, 296-318.

Karlsson, S. (2013) Chapter 15-Forecasting with Bayesian Vector Autoregression. In Elliott, G. and
            Timmermann, A. Handbook of Economic Forecasting, Volume 2, 791–89, Elsevier.
}
