% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{toydata}
\alias{toydata}
\title{A Toy Example of 1000 Respondents Working on a Multistage Test}
\format{
A list with 7 elements:
\describe{
  \item{resp}{The response matrix, with rows corresponding to respondents and columns corresponding to items.}
  \item{it}{A matrix of item parameters. The columns contain the discrimination, difficulty, pseudo-guessing and
  inattention parameters of the 4PL models. The discrimination parameters were drawn from a N(1,0.2) distribution.
  The difficulty parameters were drawn from normal distributions. For module 1 (items 1-7), this distributions was N(0,1),
  for modules 2 and 4 (items 8-14 and 22-28) it was N(1,1) and for modules 3 and 5 (items 15-21 and 29-35)
  the distribution was N(-1,1).}
  \item{theta}{The true ability parameters.}
  \item{theta_est}{The ability parameters estimated by the WLE estimator.}
  \item{group_categ}{A simulated categorical person covariate. The first 500 respondents belong to group 0, the remaining 500
  respondents to group 1.}
  \item{group_cont}{A simulated continuous person covariate. It simulates an age covariate, with a uniform distribution between
  20 and 60.}
  \item{see_est}{The standard errors of the estimated ability parameters.}
}
}
\usage{
toydata
}
\description{
Data of 1000 respondents working on a multistage test using a (1,2,2) design. The responses were generated
based on the 2PL model. Each module consists of 7 items. Data were generated using the mstR package, version 1.2
(https://cran.r-project.org/web/packages/mstR/index.html).
}
\keyword{datasets}
