% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{msma}
\alias{msma}
\alias{msma.default}
\alias{print.msma}
\title{Multiblock Sparse Multivariable Analysis}
\usage{
msma(X, ...)

\method{msma}{default}(X, Y = NULL, Z = NULL, comp = 2, lambdaX = NULL,
  lambdaY = NULL, eta = 1, type = "lasso", inX = NULL, inY = NULL,
  muX = 0, muY = 0, defmethod = "canonical", scaling = TRUE,
  verbose = FALSE, intseed = 1, ...)

\method{print}{msma}(x, ...)
}
\arguments{
\item{X}{a matrix or list of matrices indicating the explanatory variable(s). This parameter is required.}

\item{...}{further arguments passed to or from other methods.}

\item{Y}{a matrix or list of matrices indicating objective variable(s). This is optional. If there is no input for Y, then PCA is implemented.}

\item{Z}{a vector, response variable(s) for implementing the supervised version of (multiblock) PCA or PLS. This is optional. The length of Z is the number of subjects. If there is no input for Z, then unsupervised PLS/PCA is implemented.}

\item{comp}{numeric scalar for the number of components to be considered.}

\item{lambdaX}{numeric vector of regularized parameters for X, with a length equal to the number of blocks. If lambdaX is omitted, no regularization is conducted.}

\item{lambdaY}{numeric vector of regularized parameters for Y, with a length equal to the number of blocks. If lambdaY is omitted, no regularization is conducted.}

\item{eta}{numeric scalar indicating the parameter indexing the penalty family. This version contains only choice 1.}

\item{type}{a character, indicating the penalty family. In this version, only one choice is available: "lasso."}

\item{inX}{a vector or list of numeric vectors specifying the variables in X, always included in the model}

\item{inY}{a vector or list of numeric vectors specifying the variables in Y, always included in the model}

\item{muX}{a numeric scalar for the weight of X for the supervised case. 0 <= muX <= 1.}

\item{muY}{a numeric scalar for the weight of Y for the supervised case. 0 <= muY <= 1.}

\item{defmethod}{a character representing the deflation method. This version has only the choice "canonical."}

\item{scaling}{a logical, indicating whether or not data scaling is performed. The default is TRUE.}

\item{verbose}{information}

\item{intseed}{seed number for the random number in the parameter estimation algorithm.}

\item{x}{an object of class "\code{msma}." Usually, a result of a call to \code{\link{msma}}}
}
\value{
\item{dmode}{Indicates mode "PLS" or "PCA"}

\item{X}{Scaled X, which has a list form.}

\item{Y}{Scaled Y, which has a list form.}

\item{Xscale}{Scaling information for X. The mean and standard deviation values for each block of X are returned.}

\item{Yscale}{Scaling information for Y. The mean and standard deviation values for each block of Y are returned.}

\item{comp}{Number of components}

\item{wbX}{Block loading for X. The list has the same length as that of the input list X (number of blocks) and consists of a matrix. The number of variables is present in the row and the number of components is present in the column.}

\item{sbX}{Block score for X. The list has the same length as that of the input list X (number of blocks) and consists of a matrix, with the number of subjects in the row and the number of components in the column.}

\item{wbY}{Block loading for Y. The list has same length as that of the input list Y (number of blocks) and consists of a matrix, with the number of variables in the row and the number of components in the column.}

\item{sbY}{Block score for Y. The list has same length as that of the input list Y (number of blocks) and consists of a matrix, with the number of subjects in the row and the number of components in the column.}

\item{ssX}{Super score for X. In the matrix, the number of subjects is in the row and the number of components is in the column.}

\item{wsX}{Super loading for X. In the matrix, the number of blocks is in the row and the number of components is in the column.}

\item{ssY}{Super score for Y. In the matrix, the number of subjects is in the row and the number of components is in the column.}

\item{wsY}{Super loading for Y. In the matrix, the number of blocks is in the row and the number of components is in the column.}

\item{nzwbX}{Number of nonzeros in block loading for X}

\item{nzwbY}{Number of nonzeros in block loading for Y}

\item{selectXnames}{Names of selected variables for X. This returns from the original names of X}

\item{selectYnames}{Names of selected variables for Y. This returns from the original names of Y}
}
\description{
This is a function for a matrix decomposition method incorporating sparse and supervised modeling for a multiblock multivariable data analysis
}
\details{
\code{msma} requires at least one input X (a matrix or list). In this case, (multiblock) PCA is conducted. If Y is also specified, then a PLS is conducted using X as explanatory variables and Y as objective variables. This function scales each data matrix to a mean of 0 and variance of 1 in the default. The block structure can be represented as a list. If Z is also specified, a supervised version is implemented, and the degree is controlled by muX or muY, where 0 <= muX <= 1, 0 <= muY <= 1, and 0 <= muX + muY < 1. If a positive lambdaX or lambdaY is specified, then a sparse estimation based on the L1 penalty is implemented.
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### One Component #####
fit1 = msma(X, Y, comp=1, lambdaX=2, lambdaY=1:3)
fit1

##### Two Component #####
fit2 = msma(X, Y, comp=2, lambdaX=2, lambdaY=1:3)
fit2

##### Matrix data #####
sigma = matrix(0.8, 10, 10)
diag(sigma) = 1
X2 = rmvnorm(50, rep(0, 10), sigma)
Y2 = rmvnorm(50, rep(0, 10), sigma)

fit3 = msma(X2, Y2, comp=1, lambdaX=2, lambdaY=2)
fit3

##### Sparse Principal Component Analysis #####
fit5 = msma(X2, comp=5, lambdaX=2.5)
summary(fit5)

}
