% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncotree_to_umls.R
\name{umls_to_oncotree}
\alias{umls_to_oncotree}
\title{Map UMLS to OncoTree codes}
\usage{
umls_to_oncotree(
  umls_code = NULL,
  oncotree_version = "oncotree_latest_stable",
  expand = FALSE
)
}
\arguments{
\item{umls_code}{UMLS codes.}

\item{oncotree_version}{OncoTree database release version.}

\item{expand}{Whether to expand one-to-many mappings. If \code{TRUE}, one-to-many mappings are expanded into several rows in the output.}
}
\value{
A \link[tibble:tibble-package]{tibble} of two variables: \code{umls_code} and \code{oncotree_code}.
}
\description{
This function maps Unified Medical Language System (UMLS) codes to OncoTree codes.
}
\examples{
# Leave `umls_code` empty to return mappings for all UMLS codes
umls_to_oncotree()

# Map a few selected OncoTree codes
umls_to_oncotree(umls_code = c('C0206642', 'C0600113', 'C0279654', 'C1707436'))

# Use `expand` to make sure the column `oncotree_code` is a character vector and
# not a list-column. One-to-many mappings will result in more than row with
# `oncotree_code` values repeated.
umls_to_oncotree(umls_code = c('C0206642', 'C0600113', 'C0279654', 'C1707436'), expand = TRUE)

}
