library(msgl)

# warnings = errors
options(warn=2)

### Basic tests

data(SimData)
x <- sim.data$x
classes <- sim.data$classes

set.seed(100L)

lambda <- msgl.lambda.seq(x, classes, alpha = .5, d = 25L, lambda.min = 0.05, standardize = TRUE)

fit.cv <- msgl.cv(x, classes, alpha = .5, lambda = lambda, standardize = TRUE)

err.count <- colSums(fit.cv$classes != classes)

if(err.count[1] < 80 | err.count[25] > 30) stop()

# Test response format
if( ! all(dim(fit.cv$link[[1]]) == c(10, 100))) stop()
if( ! all(dim(fit.cv$response[[1]]) == c(10, 100))) stop()
if( ! all(dim(fit.cv$classes) == c(100, 25))) stop()

# some navigation tests
features_stat(fit.cv)
parameters_stat(fit.cv)
best_model(fit.cv)
