% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msgl_fit.R
\name{msgl}
\alias{msgl}
\title{Fit a multinomial sparse group lasso regularization path.}
\usage{
msgl(x, classes, sampleWeights = rep(1/length(classes), length(classes)),
  grouping = NULL, groupWeights = NULL, parameterWeights = NULL,
  alpha = 0.5, standardize = TRUE, lambda, return = 1:length(lambda),
  intercept = TRUE, sparse.data = is(x, "sparseMatrix"),
  algorithm.config = msgl.standard.config)
}
\arguments{
\item{x}{design matrix, matrix of size \eqn{N \times p}.}

\item{classes}{classes, factor of length \eqn{N}.}

\item{sampleWeights}{sample weights, a vector of length \eqn{N}.}

\item{grouping}{grouping of features, a vector of length \eqn{p}. Each element of the vector specifying the group of the feature.}

\item{groupWeights}{the group weights, a vector of length \eqn{m} (the number of groups).
If \code{groupWeights = NULL} default weights will be used.
Default weights are 0 for the intercept and
\deqn{\sqrt{K\cdot\textrm{number of features in the group}}}
for all other weights.}

\item{parameterWeights}{a matrix of size \eqn{K \times p}.
If \code{parameterWeights = NULL} default weights will be used.
Default weights are is 0 for the intercept weights and 1 for all other weights.}

\item{alpha}{the \eqn{\alpha} value 0 for group lasso, 1 for lasso, between 0 and 1 gives a sparse group lasso penalty.}

\item{standardize}{if TRUE the features are standardize before fitting the model. The model parameters are returned in the original scale.}

\item{lambda}{the lambda sequence for the regularization path.}

\item{return}{the indices of lambda values for which to return a the fitted parameters.}

\item{intercept}{should the model fit include intercept parameters (note that due to standardization the returned beta matrix will always have an intercept column)}

\item{sparse.data}{if TRUE \code{x} will be treated as sparse, if \code{x} is a sparse matrix it will be treated as sparse by default.}

\item{algorithm.config}{the algorithm configuration to be used.}
}
\value{
\item{beta}{the fitted parameters -- a list of length \code{length(lambda)} with each entry a matrix of size \eqn{K\times (p+1)} holding the fitted parameters}
\item{loss}{the values of the loss function}
\item{objective}{the values of the objective function (i.e. loss + penalty)}
\item{lambda}{the lambda values used}
\item{classes.true}{the true classes used for estimation, this is equal to the \code{classes} argument}
}
\description{
Fit a sequence of multinomial logistic regression models using sparse group lasso, group lasso or lasso.
In addition to the standard parameter grouping the algorithm supports further grouping of the features.
}
\details{
For a classification problem with  \eqn{K} classes and \eqn{p} features (covariates) dived into \eqn{m} groups.
This function computes a sequence of minimizers (one for each lambda given in the \code{lambda} argument) of
\deqn{\hat R(\beta) + \lambda \left( (1-\alpha) \sum_{J=1}^m \gamma_J \|\beta^{(J)}\|_2 + \alpha \sum_{i=1}^{n} \xi_i |\beta_i| \right)}
where \eqn{\hat R} is the weighted empirical log-likelihood risk of the multinomial regression model.
The vector \eqn{\beta^{(J)}} denotes the parameters associated with the \eqn{J}'th group of features
(default is one covariate per group, hence the default dimension of \eqn{\beta^{(J)}} is \eqn{K}).
The group weights \eqn{\gamma \in [0,\infty)^m} and parameter weights \eqn{\xi \in [0,\infty)^n} may be explicitly specified.
}
\examples{
data(SimData)
x <- sim.data$x
classes <- sim.data$classes
lambda <- msgl.lambda.seq(x, classes, alpha = .5, d = 50, lambda.min = 0.05)
fit <- msgl(x, classes, alpha = .5, lambda = lambda)

# Model 10, i.e. the model corresponding to lambda[10]
models(fit)[[10]]

# The nonzero features of model 10
features(fit)[[10]]

# The nonzero parameters of model 10
parameters(fit)[[10]]

# The training errors of the models.
Err(fit, x)
# Note: For high dimensional models the training errors are almost always over optimistic,
# instead use msgl.cv to estimate the expected errors by cross validation

}
\author{
Martin Vincent
}

