#' Exemplary person year table
#'
#' Data set of fatal lung cancer in rats exposed to Radon at Pacific Northwest National Laboratory.
#' For each rat, the age at start of Radon exposure, the age at end of exposure and the age at end of follow-up/death
#' is provided in weeks.
#' The Radon dose rate is given in WL (working level).
#'
#' @docType data
#'
#' @usage data(lungCancerRadon)
#'
#' @format Data frame with 5 variables.
#'
#' @keywords datasets
#'
#' @source Pacific Northwest National Laboratory, see 
#' Heidenreich, W, Jacob P, Paretzke H., et al. (1999). Radiation research, 151 2, 209-17 DOI:10.2307/3579772.
#'
#' @examples
#' data(lungCancerRadon)
#' lungCancerRadon[1000,]
"lungCancerRadon"