\name{msarc.loadTerms}
\alias{msarc.loadTerms}
\alias{msarc.saveTerms}
\alias{msarc.getTerms}
\alias{msarc.filterTerms}
\title{Manipulate GO Term Lists}
\description{
Removing uninteresting GO terms from the list of terms relevant to a set
of UniProt accessions must be done manually.  \code{msarc.saveTerms} and
\code{msarc.loadTerms} allow
the user to save the list of GO terms from a given \code{msarc} object to
a file for manual filtering, then re-load the filtered file.
\code{msarc.getTerms} and \code{msarc.filterTerms} allow the user to retrieve
the list of GO terms as a data frame, filter it manually, and update the
\code{msarc} object with the filtered list.
}
\usage{
msarc.saveTerms(msarc, filename="go_terms.txt")
msarc.loadTerms(msarc, filename="go_terms.txt")
msarc.getTerms(msarc)
msarc.filterTerms(msarc, keepers)
}
\arguments{
  \item{msarc}{an \code{msarc} object.}
  \item{filename}{the name of a file to load from or save to.}
  \item{keepers}{a filtered data frame from \code{msarc.getTerms}, or a 
                 vector of GO IDs to keep.}
}
\details{
The file generated by \code{msarc.saveTerms} must be modified only by
having complete lines containing unwanted GO terms deleted.

\code{msarc.getTerms} returns the list of GO terms as a data frame, with
columns for the GO ID, name of the category, and number of proteins in this
category.  The user can filter this list manually, then use
\code{msarc.filterTerms} to indicate which categories should be represented
in the final plot.  \code{msarc.filterTerms} is passed an \code{msarc}
object, and either a filtered data frame from \code{msarc.getTerms} or a
vector of Uniprot IDs.
}
\value{\code{msarc.loadTerms} and \code{msarc.filterTerms} return the modified
\code{msarc} object.

\code{msarc.saveTerms} returns nothing.

\code{msarc.getTerms} returns a 3-column data frame: GO ID, GO category name,
count of the number of proteins that match this category.
}
\author{Gord Brown}
\examples{
data(sample_goterms,package="msarc")
\dontrun{msarc.saveTerms(sample_goterms)}
\dontrun{sample_filtered <- msarc.loadTerms(sample_goterms,"terms.txt")}
tbl <- msarc.getTerms(sample_goterms)
tbl <- tbl[c("GO:0017076","GO:0030554","GO:0032553","GO:0032555","GO:0032559",
             "GO:0035639","GO:0036094","GO:0097159","GO:0017111","GO:0016462"),]
sample_filtered <- msarc.filterTerms(sample_goterms,tbl)
}
\keyword{IO}
\keyword{file}
