% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwrite.R
\name{mwrite_cpp}
\alias{mwrite_cpp}
\title{Write a model to native mrgsolve format}
\usage{
mwrite_cpp(x, file, update = TRUE)
}
\arguments{
\item{x}{a model object.}

\item{file}{output file name; if non-character (e.g., \code{NULL}), no output
will be written to file.}

\item{update}{\code{TRUE} if model settings should be written into the cpp file in
a \verb{$SET} block.}
}
\value{
A list containing data that was written out to the cpp file, with added
item \code{file}, is returned invisibly.
}
\description{
Model code is written to a file in native mrgsolve format. This
can be useful for (1) breaking connection to NONMEM modeling outputs that
are imported by \verb{$NMXML} or \verb{$NMEXT} and (2) saving model updates (e.g.,
an updated parameter list). Models can be read back using \code{\link[=mread]{mread()}}.
}
\details{
See important details in \code{\link[=mwrite_yaml]{mwrite_yaml()}}.
}
\examples{
temp <- tempfile(fileext = ".mod")

mod <- modlib("pk1", compile = FALSE)

x <- mwrite_cpp(mod, file = temp)

mod <- mread(x$file, compile = FALSE)

mod

}
\seealso{
\code{\link[=mwrite_yaml]{mwrite_yaml()}}, \code{\link[=yaml_to_cpp]{yaml_to_cpp()}}
}
