% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseq.R
\name{parseq_range}
\alias{parseq_range}
\title{Simulation helper to generate a sequence of parameters from a range}
\usage{
parseq_range(mod, ..., .n = 5, .geo = TRUE, .digits = NULL)
}
\arguments{
\item{mod}{mrgsolve model object}

\item{...}{unquoted parameter names,}

\item{.n}{number of values to simulate for each parameter sequence}

\item{.geo}{if \code{TRUE} generate a geometric sequence; otherwise,
generate a sequence evenly spaced on Cartesian scale; see \code{\link[=seq_geo]{seq_geo()}}}

\item{.digits}{if \code{numeric}, the number of significant digits in the
parameter sensitivity values are set using \code{\link[=signif]{signif()}}}
}
\description{
Simulation helper to generate a sequence of parameters from a range
}
\details{
\itemize{
\item \code{.n}  is passed to \code{\link[=seq_geo]{seq_geo()}} as \code{n}
}
}
\examples{
mod <- mrgsolve::house()

mod \%>\%
  parseq_range(CL = c(0.5,1),VC = c(10,40)) \%>\% 
  sens_each()

}
\seealso{
\code{\link[=parseq_cv]{parseq_cv()}}, \code{\link[=parseq_fct]{parseq_fct()}}, \code{\link[=parseq_manual]{parseq_manual()}}
}
