% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{metadatamrbin}
\alias{metadatamrbin}
\title{A function for interactively editing metadata of mrbin objects.}
\usage{
metadatamrbin(mrbinResults, metadata = NULL)
}
\arguments{
\item{mrbinResults}{An mrbin object}

\item{metadata}{An optional list of objects to be changed. If provided, interactive mode is deactivated}
}
\value{
An invisible mrbin object
}
\description{
This function edits interactively or non-interactively the metadata filed of the provided mrbin object.
}
\examples{
 mrbinObject<-mrbin(silent=TRUE,
                   parameters=list(verbose=TRUE,dimension="1D",PQNScaling="No",
                   binwidth1D=0.04,signal_to_noise1D=1,PCA="No",binRegion=c(9.5,0.5,10,156),
                   saveFiles="No",referenceScaling="No",noiseRemoval="No",
                   fixNegatives="No",logTrafo="No",noiseThreshold=.05,tryParallel=FALSE,
                   NMRfolders=c(system.file("extdata/2/10/pdata/10",package="mrbin"),
                              system.file("extdata/3/10/pdata/10",package="mrbin"))
                   ))
 mrbinObject<-metadatamrbin(mrbinObject,metadata=list(projectTitle="Test project"))
}
