% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL_R2.R
\name{QTL_R2}
\alias{QTL_R2}
\title{QTL global and partial R squared}
\usage{
QTL_R2(mppData, trait = 1, QTL = NULL, Q.eff = "cr", glb.only = FALSE)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{QTL}{Object of class \code{QTLlist} representing a list of
selected position obtained with the function \code{\link{QTL_select}} or
vector of \code{character} marker positions names.
Default = NULL.}

\item{Q.eff}{\code{Character} expression indicating the assumption concerning
the QTL effects: 1) "cr" for cross-specific; 2) "par" for parental; 3) "anc"
for ancestral; 4) "biall" for a bi-allelic. For more details see
\code{\link{mpp_SIM}}. Default = "cr".}

\item{glb.only}{\code{Logical} value. If glb.only = TRUE, only the global and 
global adjusted R squared will be returned. Default = FALSE.}
}
\value{
Return:

object of class \code{QR2Res} containing the following objects:

\item{glb.R2 }{ Global R squared of all QTL terms.}

\item{glb.adj.R2 }{ Global adjusted R squared of all QTL terms.}

\item{part.R2.diff }{ Vector of partial R squared doing
the difference between the full model and a model minus the ith QTL.}

\item{part.adj.R2.diff }{ Vector of partial adjusted R squared doing
the difference between the full model and a model minus the ith QTL.}

\item{part.R2.sg }{ Vector of partial R squared using only the ith QTL.}

\item{part.adj.R2.sg }{ Vector of partial adjusted R squared using only the
ith QTL.}
}
\description{
Computes the global and partial (adjusted) R squared of a  list of QTLs using
a linear model.
}
\details{
The function computes R squared statistics using a linear model. The extra
variance explained by a full model containing the QTL terms with respect
to a reduced model containing only the cross intercept terms and uses the
ratio between the residual sum of square of these two models:
R2 = 1-(RSS(f))/(RSS(r)).

Partial R squared for each individual QTL position can also be calculated.
Two types of partial R squared are returned. The first one
uses the difference between the R squared obtained with all QTL
positions and the R squared obtain with all position minus the ith one
(difference R squared). The second method used only the ith QTL position
in the model (single R squared).

For both global and partial R squared, it is possible to obtained adjusted
measurements taking the number of degrees of freedom into consideration using
an adaptation of the formula given by Utz et al. (2000):
R.adj = R-(z/(N-z-n.cr))*(1-R) where z is the total
number of estimated components of the genetic effect. N is the total number
of phenotypic information, and n.cr is the number of intercept (cross) terms.
}
\examples{

data(mppData)

SIM <- mpp_SIM(mppData)
QTL <- QTL_select(Qprof = SIM, threshold = 3, window = 20)
Q_R2 <- QTL_R2(mppData = mppData, QTL = QTL, Q.eff = "cr")
summary(Q_R2)


}
\references{
Utz, H. F., Melchinger, A. E., & Schon, C. C. (2000). Bias and sampling error
of the estimated proportion of genotypic variance explained by quantitative
trait loci determined from experimental data in maize using cross validation
and validation with independent samples. Genetics, 154(4), 1839-1849.
}
\seealso{
\code{\link{QTL_select}}, \code{\link{summary.QR2Res}}
}
\author{
Vincent Garin
}
