% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplot-package.R
\docType{data}
\name{bodyfat}
\alias{bodyfat}
\title{Body fat data set}
\format{A data frame with 128 observations on 15 variables.
\describe{
\item{Id}{Identifier}
\item{Bodyfat}{Bodyfat percentage}
\item{Age}{Age (years)}
\item{Weight}{Weight (kg)}
\item{Height}{Height (inches)}
\item{Neck}{Neck circumference (cm)}
\item{Chest}{Chest circumference (cm)}
\item{Abdo}{Abdomen circumference (cm) "at the umbilicus
and level with the iliac crest"}
\item{Hip}{Hip circumference (cm)}
\item{Thigh}{Thigh circumference (cm)}
\item{Knee}{Knee circumference (cm)}
\item{Ankle}{Ankle circumference (cm)}
\item{Bic}{Extended biceps circumference (cm)}
\item{Fore}{Forearm circumference (cm)}
\item{Wrist}{Wrist circumference (cm) "distal to the
styloid processes"}
}}
\usage{
data(bodyfat)
}
\description{
A data frame with 128 observations on 15 variables.
}
\details{
A subset of the 252 observations available in the \code{mfp} package.
The selected observations avoid known high leverage points and
outliers.  The unused points from the data set could be used to validate
selected models.
}
\examples{
data(bodyfat)
full.mod = lm(Bodyfat~.,data=subset(bodyfat,select=-Id))
}
\references{
Johnson W (1996, Vol 4). Fitting percentage of
body fat to simple body measurements. Journal of Statistics
Education. Bodyfat data retrieved from
http://www.amstat.org/publications/jse/v4n1/datasets.johnson.html
An expanded version is included in the \code{mfp} R package.
}
\keyword{datasets}
