% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_mpi.R
\name{save_mpi}
\alias{save_mpi}
\title{Save MPI Output}
\usage{
save_mpi(
  .mpi_output,
  .mpi_specs = getOption("mpi_specs"),
  .filename = NULL,
  .formatted_output = TRUE,
  .include_table_summary = TRUE,
  .include_specs = FALSE
)
}
\arguments{
\item{.mpi_output}{An object derived from \link[mpindex]{compute_mpi}.}

\item{.mpi_specs}{MPI specifications defined in \code{\link[mpindex]{define_mpi_specs}}.}

\item{.filename}{Output filename}

\item{.formatted_output}{Whether formatting is to be applied to the output.}

\item{.include_table_summary}{NOT YET IMPLEMENTED. Whether to include summary information in the generated output.}

\item{.include_specs}{NOT YET IMPLEMENTED. Whether to include MPI specification in the generated output.}
}
\value{
Returns the file location of the output generated.
}
\description{
Save the MPI ouput into an Excel file format.
}
\examples{
\dontrun{
# It requires an MPI output (list type) in the first argument
save_mpi(mpi_result, .filename = 'MPI Sample Output')
}
}
