% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_extract.R
\name{tidy.cmp}
\alias{tidy.cmp}
\title{Tidy a(n) CMP model object}
\usage{
\method{tidy}{cmp}(x, conf.int = FALSE, conf.level = 0.95, exponentiate = FALSE, ...)
}
\arguments{
\item{x}{an object class 'cmp' object, obtained from a call to \code{glm.cmp}}

\item{conf.int}{Logical indicating whether or not to include a confidence interval in the tidied output. Defaults to FALSE.}

\item{conf.level}{The confidence level to use for the confidence interval if conf.int = TRUE. Must be strictly greater than 0 and less than 1. Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{exponentiate}{Logical indicating whether or not to exponentiate the the coefficient estimates.}

\item{...}{other arguments passed to or from other methods  (currently unused).}
}
\value{
A \code{tibble::tibble()} with columns:
\item{term}{The name of the regression term.}
\item{estimate}{The estimated value of the regression term.}
\item{std.error}{The standard error of the regression term.}
\item{statistic}{The value of a test statistic to use in a hypothesis that the regression term is non-zero.}
\item{p.value}{The two-sided p-value associated with the observed statistic based on asymptotic normality.}
\item{parameter}{Only for varying dispersion models. Type of coefficient being estimated: 'mu', 'nu'}
\item{conf.low}{Lower bound on the confidence interval for the estimate.}
\item{conf.high}{Upper bound on the confidence interval for the estimate.}
}
\description{
Tidy summarizes information about the components of a model. A model component might be a single term in a regression, a single hypothesis, a cluster, or a class. Exactly what tidy considers to be a model component varies across models but is usually self-evident. If a model has several distinct types of components, you will need to specify which components to return.
}
\examples{
data(attendance)
M.attendance <- glm.cmp(daysabs~ gender+math+prog, data=attendance)
tidy(M.attendance)
}
