% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_extract.R
\name{augment.cmp}
\alias{augment.cmp}
\title{Augment data with information from a(n) CMP model object}
\usage{
\method{augment}{cmp}(
  x,
  data = model.frame.cmp(x),
  newdata = NULL,
  type.predict = c("link", "response"),
  type.residuals = c("deviance", "pearson", "response"),
  se_fit = FALSE,
  ...
)
}
\arguments{
\item{x}{an object class 'cmp' object, obtained from a call to \code{\link{glm.cmp}}}

\item{data}{A base::data.frame or \code{tibble::tibble()} containing the original data that was used to produce the object x. Defaults to model.frame.cmp(x) so that augment(my_fit) returns the augmented original data. \strong{Do not} pass new data to the data argument. Augment will report information such as influence and cooks distance for data passed to the data argument. These measures are only defined for the original training data.}

\item{newdata}{A \code{base::data.frame()} or \code{tibble::tibble()} containing all the original predictors used to create x. Defaults to NULL, indicating that nothing has been passed to newdata. If newdata is specified, the data argument will be ignored.}

\item{type.predict}{Passed to \code{\link{predict.cmp}()} type argument. Defaults to \code{"link"}.}

\item{type.residuals}{Passed to \code{\link{residuals.cmp}()} type arguments. Defaults to \code{"deviance"}.}

\item{se_fit}{Logical indicating whether or not a .se.fit column should be added to the augmented output. Defaults to \code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic signature only. Cautionary note: Misspelled arguments will be absorbed in ..., where they will be ignored. If the misspelled argument has a default value, the default value will be used. For example, if you pass conf.level = 0.9, all computation will proceed using conf.level = 0.95. Additionally, if you pass newdata = my_tibble to an augment() method that does not accept a newdata argument, it will use the default value for the data argument.}
}
\value{
A \code{tibble::tibble()} with columns:
\item{.cooksd}{Cooks distance.}
\item{.fitted}{Fitted or predicted value.}
\item{.hat}{Diagonal of the hat matrix.}
\item{.resid}{The difference between observed and fitted values.}
\item{.se.fit}{Standard errors of fitted values.}
\item{.sigma}{Estimated residual standard deviation when corresponding observation is dropped from model.}
\item{.std.resid}{Standardised residuals.}
}
\description{
Augment accepts a model object and a dataset and adds information about each observation in the dataset. Most commonly, this includes predicted values in the .fitted column, residuals in the .resid column, and standard errors for the fitted values in a .se.fit column. New columns always begin with a . prefix to avoid overwriting columns in the original dataset.
}
\details{
Users may pass data to augment via either the data argument or the newdata argument. If the user passes data to the data argument, it must be exactly the data that was used to fit the model object. Pass datasets to newdata to augment data that was not used during model fitting. This still requires that all columns used to fit the model are present.

Augment will often behave differently depending on whether data or newdata is given. This is because there is often information associated with training observations (such as influences or related) measures that is not meaningfully defined for new observations.

For convenience, many augment methods provide default data arguments, so that augment(fit) will return the augmented training data. In these cases, augment tries to reconstruct the original data based on the model object with varying degrees of success.

The augmented dataset is always returned as a \code{tibble::tibble} with the \strong{same number of rows} as the passed dataset. This means that the passed data must be coercible to a tibble.

We are in the process of defining behaviours for models fit with various na.action arguments, but make no guarantees about behaviour when data is missing at this time.
}
\examples{
data(attendance)
M.attendance <- glm.cmp(daysabs~ gender+math+prog, data=attendance)
augment(M.attendance)
}
