% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoParentPedigree.R
\name{twoParentPedigree}
\alias{twoParentPedigree}
\title{Generate a two-parent pedigree which starts from inbred founders}
\usage{
twoParentPedigree(
  initialPopulationSize,
  selfingGenerations,
  nSeeds = 1L,
  intercrossingGenerations
)
}
\arguments{
\item{initialPopulationSize}{The number of F1 lines generated}

\item{selfingGenerations}{The number of selfing generations at the end of the pedigree}

\item{nSeeds}{The number of progeny taken from each intercrossing line, or from each F1 if no intercrossing is specified. These lines are then selfed according to selfingGenerations}

\item{intercrossingGenerations}{The number of generations of random mating performed from the F1 generation. Population size is maintained at that specified by initialPopulationSize}
}
\value{
An object of class \code{detailedPedigree} representing the experimental design, suitable for simulation using simulateMPCross.
}
\description{
Generate a two-parent pedigree starting from inbred founders
}
\examples{
plotWOptions <- function(graph) 
	plot(graph, vertex.size = 8, vertex.label.cex=0.6, edge.arrow.size=0.01, edge.width=0.2)
#F2 design
pedigree <- twoParentPedigree(initialPopulationSize = 10, selfingGenerations = 1, 
	intercrossingGenerations = 0, nSeeds = 1)
graph <- pedigreeToGraph(pedigree)
plotWOptions(graph)

#An equivalent F2 design (if the founders really are inbred)
pedigree <- twoParentPedigree(initialPopulationSize = 10, selfingGenerations = 0, 
	intercrossingGenerations = 1, nSeeds = 0)
graph <- pedigreeToGraph(pedigree)
plotWOptions(graph)

#Another equivalent F2 design (if the founders really are inbred)
pedigree <- twoParentPedigree(initialPopulationSize = 1, selfingGenerations = 1, 
	intercrossingGenerations = 0, nSeeds=10)
graph <- pedigreeToGraph(pedigree)
plotWOptions(graph)

#A RIL design (10 generations of inbreeding)
pedigree <- twoParentPedigree(initialPopulationSize = 10, selfingGenerations = 10, 
	intercrossingGenerations = 0, nSeeds = 1)
graph <- pedigreeToGraph(pedigree)
plotWOptions(graph)

#Another RIL design (10 generations of inbreeding)
pedigree <- twoParentPedigree(initialPopulationSize = 1, selfingGenerations = 10, 
	intercrossingGenerations = 0, nSeeds = 10)
graph <- pedigreeToGraph(pedigree)
plotWOptions(graph)
#One generation of mixing followed by 10 generations of inbreeding
pedigree <- twoParentPedigree(initialPopulationSize = 10, selfingGenerations = 10, 
	intercrossingGenerations = 1, nSeeds = 1)
graph <- pedigreeToGraph(pedigree)
plotWOptions(graph)

#Two generations of mixing and no inbreeding
pedigree <- twoParentPedigree(initialPopulationSize = 10, selfingGenerations = 0, 
	intercrossingGenerations = 2, nSeeds = 0)
graph <- pedigreeToGraph(pedigree)
plotWOptions(graph)

#One generation of mixing, and then two selfed lines are generated (10 generations of selfing)
pedigree <- twoParentPedigree(initialPopulationSize = 10, selfingGenerations = 10, 
	intercrossingGenerations = 1, nSeeds = 2)
graph <- pedigreeToGraph(pedigree)
plotWOptions(graph)
}
