% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{pedigree}
\alias{pedigree}
\title{Create a pedigree object}
\usage{
pedigree(lineNames, mother, father, selfing, warnImproperFunnels = TRUE)
}
\arguments{
\item{lineNames}{The names of the genetic lines}

\item{mother}{The index of the maternal line}

\item{father}{The index of the paternal line}

\item{selfing}{Should the number of generations of selfing be taken from the pedigree (\code{"finite"}), or should selfing be assumed to be infinite (\code{"infinite"})?}

\item{warnImproperFunnels}{Should a warning be generated in subsequent computations using this pedigree, if there are lines which do not contain all founding lines as ancestors?}
}
\value{
An object of class \code{pedigree} representing the inputs.
}
\description{
Create a pedigree object
}
\details{
This function creates a pedigree object from parts. All lines are assumed to have an index, starting at 1 for the first line. Values at index of the various inputs 1 all relate to the first line, values at index 2 all relate to the second line, etc. 

Input \code{lineNames} assigns a name to every line. Input \code{mother} gives the index of a mother line, where a value of 0 indicates that a line is a founder of the population (and therefore inbred). Input \code{father} gives the index of a father line, where a value of 0 indicates that a line is a founder of the population (and therefore inbred). Input \code{selfing} must be \code{"finite"} or \code{"infinite"}. A value of infinite means that the number of generations of selfing for this pedigree will be assumed to be infinite. A value of \code{"finite"} means that the number of generations of selfing will be computed from the pedigree, for every line.
}
