% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eightWayPedigreeRandomFunnels.R
\name{eightParentPedigreeRandomFunnels}
\alias{eightParentPedigreeRandomFunnels}
\title{Generate an eight-parent pedigree, using random funnels}
\usage{
eightParentPedigreeRandomFunnels(
  initialPopulationSize,
  selfingGenerations,
  nSeeds = 1L,
  intercrossingGenerations
)
}
\arguments{
\item{initialPopulationSize}{The number of initially generated lines, whose genetic material is a mosaic of the eight founding lines. These lines are generated using three generations of structured mating.}

\item{selfingGenerations}{The number of selfing generations at the end of the pedigree.}

\item{nSeeds}{The number of progeny taken from each intercrossing line, or from each initially generated line (if no intercrossing is specified). These lines are then selfed according to selfingGenerations.}

\item{intercrossingGenerations}{The number of generations of random mating performed from the F1 generation. Population size is maintained at that specified by initialPopulationSize.}
}
\value{
An object of class \code{detailedPedigree} representing the experimental design, suitable for simulation using simulateMPCross.
}
\description{
Generate a eight-parent pedigree starting from inbred founders, using a random funnel.
}
\examples{
pedigree <- eightParentPedigreeRandomFunnels(initialPopulationSize = 10, 
	selfingGenerations = 0, nSeeds = 1, intercrossingGenerations = 10)
#Generate map
map <- qtl::sim.map()
#Simulate data
cross <- simulateMPCross(map = map, pedigree = pedigree, mapFunction = haldane)
#Get out a list of funnels, which are rows of this matrix. For this pedigree, every 
#    funnel is a random ordering of 1:8. 
getAllFunnels(cross)
#convert the pedigree to a graph
pedigreeAsGraph <- pedigreeToGraph(pedigree)
#Plot it
\donttest{plot(pedigreeAsGraph)}
#Write it to a file in DOT format
}
\seealso{
\code{\link{eightParentPedigreeSingleFunnel}}, \code{\link{fourParentPedigreeSingleFunnel}}, \code{\link{fourParentPedigreeRandomFunnels}}, \code{\link{twoParentPedigree}}
}
