% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_move.R
\name{subset_move}
\alias{subset_move}
\title{Subset a \code{move} or \code{moveStack} object by a given time span}
\usage{
subset_move(m, from, to, tz = "UTC")
}
\arguments{
\item{m}{a \code{move} or \code{moveStack} object (see \code{\link{df2move}} to convert a \code{data.frame} to a \code{move} object).}

\item{from}{character or \code{POSIXct}, representing the start time. If character, the format \code{"\%m-\%d-\%y \%H:\%M:\%S"} must be used (see \code{\link{strptime}}).}

\item{to}{character or \code{POSIXct}, representing the stop time. If character, the format  \code{"\%m-\%d-\%y \%H:\%M:\%S"} must be used  (see \code{\link{strptime}}).}

\item{tz}{character, time zone that should be used if \code{from} and/or \code{to} are of type \code{character}.}
}
\value{
A \code{move} or \code{moveStack} object.
}
\description{
This function is a simple wrapper that subsets a \code{move} or \code{moveStack} by a given time span. A \code{move} or \code{moveStack} containing data only for the subset time span is returned.
}
\examples{
library(moveVis)
library(move)

# load the example data
data("move_data")

# check min and max of move_data timestamps
min(timestamps(move_data))
max(timestamps(move_data))

# subset by character times
m <- subset_move(move_data, from = "2018-05-15 07:00:00", to = "2018-05-15 18:00:00")

# check min and max of result
min(timestamps(m))
max(timestamps(m))

}
\seealso{
\code{\link{df2move}}
}
