% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parDef.R
\name{parDef}
\alias{parDef}
\title{Parameters definition}
\usage{
parDef(stepDist, angleDist, nbStates, estAngleMean, zeroInflation)
}
\arguments{
\item{stepDist}{Name of the distribution of the step lengths.}

\item{angleDist}{Name of the distribution of the turning angles.
Set to \code{"none"} if the angle distribution should not be estimated.}

\item{nbStates}{Number of states of the HMM.}

\item{estAngleMean}{\code{TRUE} if the mean of the turning angles distribution is estimated,
\code{FALSE} otherwise.}

\item{zeroInflation}{\code{TRUE} if the step length distribution is inflated in zero.}
}
\value{
A list of:
\item{parSize}{Vector of two values: number of parameters of the step length distribution,
number of parameters of the turning angle distribution}
\item{bounds}{Matrix with 2 columns and \code{sum(parSize)} rows - each row contains the lower and upper
bound for the correponding parameter)}
\item{parNames}{Names of parameters of step distribution (the names of the parameters of the
angle distribution are always the same).}
}
\description{
Parameters definition
}
