% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{mt_average}
\alias{mt_average}
\title{Average trajectories across intervals.}
\usage{
mt_average(data, use = "trajectories", save_as = "av_trajectories",
  dimensions = "all", av_dimension = "timestamps", intervals = NULL,
  interval_size = 100, max_interval = NULL, verbose = FALSE,
  dimension = NULL)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{save_as}{a character string specifying where the resulting trajectory
data should be stored.}

\item{dimensions}{a character vector specifying the dimensions in the
trajectory array that should be averaged. By default (\code{"all"}), all
trajectory dimensions will be averaged.}

\item{av_dimension}{a character string specifying which values should be used
for determining the intervals for averaging (\code{"timestamps"} by
default).}

\item{intervals}{an optional numeric vector. If specified, these values are
taken as the borders of the intervals (\code{interval_size} and
\code{max_interval} are ignored).}

\item{interval_size}{an integer specifying the size of the constant dimension
interval.}

\item{max_interval}{an integer specifying the upper limit of the last
dimension value that should be included (therefore, it should be a multiple
of the \code{interval_size}). If specified, only values will be used for
averaging where the dimension values are smaller than \code{max_interval}.
If unspecified (the default), all values will be included.}

\item{verbose}{logical indicating whether function should report its
progress.}

\item{dimension}{Deprecated. Please use \code{av_dimension} instead.}
}
\value{
A mousetrap data object (see \link{mt_example}) with an additional
  array (by default called \code{av_trajectories}) that contains the average
  trajectory data per dimension interval. If a trajectory array was provided
  directly as \code{data}, only the average trajectories will be returned.

  For the dimension values used for averaging (specified in
  \code{av_dimension}), the mid point of the respective interval is reported,
  which is helpful for plotting the trajectory data later on. However, this
  value does not necessarily correspond to the empirical mean of the
  dimension values in the interval.
}
\description{
Average trajectory data across specified intervals (e.g., constant time
intervals). For every specified dimension in the trajectory array (by
default, every dimension, i.e., x- and y-position, possibly also velocity and
acceleration etc.), the mean value for the respective interval is calculated
(see Details for information regarding the exact averaging procedure).
}
\details{
For each interval, it is first determined which of the values lie within the
respective interval of the dimension used for averaging (e.g., timestamps).
Intervals are left-open, right-closed (e.g., if values are averaged across
constant timestamps of 100 ms, a timestamp of 1200 would be included in the
interval 1100-1200 while a timestamp of 1300 would be included in the
interval 1200-1300). Then, all values for which the corresponding average
dimension values lie within the interval are averaged.

In case the last interval is not fully covered (e.g., if the last timestamp
has the value 1250), values for the corresponding interval (1200-1300) will
be computed based on the average of the values up to the last existing value.

Note that \code{mt_average} assumes that the trajectory variables are
recorded with a constant sampling rate (i.e., with a constant difference in
the timestamps). If the sampling rate varies considerably, \link{mt_resample}
should be called before averaging to arrive at equally spaced timestamps. The
sampling rate can be investigated using \link{mt_check_resolution}.

If average velocity and acceleration are of interest,
\link{mt_derivatives} should be called before averaging.
}
\examples{
mt_example <- mt_derivatives(mt_example)

# average trajectories across 100 ms intervals
mt_example <- mt_average(mt_example, save_as="av_trajectories",
  interval_size=100)

# average time-normalized trajectories across specific intervals
# of the time steps
mt_example <- mt_time_normalize(mt_example)
mt_example <- mt_average(mt_example,
  use="tn_trajectories", save_as="av_tn_trajectories",
  av_dimension = "steps", intervals = c(0.5,33.5,67.5,101.5))

}
\seealso{
\link{mt_derivatives} for calculating velocity and
  acceleration.

  \link{mt_resample} for resampling trajectories using a constant time
  interval.
}
\author{
Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})

Felix Henninger
}
