% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{mt_time_normalize}
\alias{mt_time_normalize}
\title{Time normalize trajectories.}
\usage{
mt_time_normalize(data, use = "trajectories", save_as = "tn_trajectories",
  nsteps = 101, show_progress = TRUE)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import 
functions (see \link{mt_example} for details). Alternatively, a trajectory 
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be 
used.}

\item{save_as}{a character string specifying where the resulting trajectory 
data should be stored.}

\item{nsteps}{an integer specifying the number of equally sized time steps.}

\item{show_progress}{logical indicating whether function should report on its
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}) with an additional
  array (by default called \code{tn_trajectories}) containing the 
  time-normalized trajectories. In this array, another dimension (called 
  \code{steps}) has been added with increasing integer values indexing the 
  time-normalized position. If a trajectory array was provided directly as
  \code{data}, only the time-normalized trajectories will be returned.
}
\description{
Compute time-normalized trajectories using a constant number of equally sized
time steps. Time normalization is performed separately for the x- and 
y-positions using linear interpolation based on the timestamps. By default, 
101 time steps are used (following Spivey et al., 2005).
}
\details{
Time-normalization is often performed if the number of recorded x- and 
y-positions varies across trajectories, which typically occurs when 
trajectories vary in their response time. After time-normalization, all 
trajectories have the same number of recorded positions (which is specified 
using \code{nsteps}) and the positions at different relative time points can 
be compared across trajectories.

For example, time normalized trajectories can be compared across conditions 
that differed in their overall response time, as the timestamps are now 
relative to the overall trial duration. This is also helpful for creating 
average trajectories, which are often used in plots.
}
\examples{
mt_example <- mt_time_normalize(mt_example,
  save_as="tn_trajectories", nsteps=101)
  
}
\references{
Spivey, M. J., Grosjean, M., & Knoblich, G. (2005). Continuous
  attraction toward phonological competitors. \emph{Proceedings of the
  National Academy of Sciences of the United States of America, 102}(29),
  10393-10398.
}
\seealso{
\link[stats]{approx} for information about the function used for
  linear interpolation.

\link{mt_resample} for resampling trajectories using a constant time
interval.
}

