% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsp_transform.R
\name{lsp_transform}
\alias{lsp_transform}
\title{Tranforms lsp objects}
\usage{
lsp_transform(x, fun, ...)
}
\arguments{
\item{x}{Object of class \code{lsp} - usually the output of
the \code{lsp_signature()} function.}

\item{fun}{A user-provided function.}

\item{...}{Additional arguments for \code{fun}.}
}
\value{
Object of class \code{lsp}.
It has three columns: (1) \code{id} - an id of each window.
For irregular windows, it is the values provided in the \code{window} argument,
(2) \code{na_prop} - share (0-1) of \code{NA} cells for each window,
(3) \code{signature} - a list-column containing with calculated signatures
}
\description{
It allows for transforming spatial signatures (outputs of
the \code{lsp_signature()} function) using user-provided functions.
See examples for more details.
}
\examples{
library(stars)
landform = read_stars(system.file("raster/landforms.tif", package = "motif"))
result_coma500 = lsp_signature(landform, type = "coma", threshold = 0.5, window = 500)

#see how the first signature looks
result_coma500$signature[[1]]

my_function = function(mat){
    mat_c = colSums(mat)
    freqs = mat_c / sum(mat)
    # entropy
    -sum(freqs * log2(freqs), na.rm = TRUE)
}

result_coma500_2 = lsp_transform(result_coma500, my_function)

#see how the first signature looks after transformation
result_coma500_2$signature[[1]]

\donttest{
# larger data example
library(stars)
landform = read_stars(system.file("raster/landform.tif", package = "motif"))
result_coma500 = lsp_signature(landform, type = "coma", threshold = 0.5, window = 500)

#see how the first signature looks
result_coma500$signature[[1]]

my_function = function(mat){
    mat_c = colSums(mat)
    freqs = mat_c / sum(mat)
    # entropy
    -sum(freqs * log2(freqs), na.rm = TRUE)
}

result_coma500_2 = lsp_transform(result_coma500, my_function)

#see how the first signature looks after transformation
result_coma500_2$signature[[1]]
}
}
