% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminators.R
\name{mosmafsTermEvals}
\alias{mosmafsTermEvals}
\alias{mosmafsTermGenerations}
\alias{mosmafsTermTime}
\alias{mosmafsTermFidelity}
\alias{mosmafsTermStagnationHV}
\alias{mosmafsTermStagnationObjStatistic}
\title{Termination Function Creator}
\usage{
mosmafsTermEvals(evals)

mosmafsTermGenerations(generations)

mosmafsTermTime(time)

mosmafsTermFidelity(fidelity)

mosmafsTermStagnationHV(stag, stag.index = "generations")

mosmafsTermStagnationObjStatistic(
  stag,
  stag.index = "generations",
  obj.stat = "mean",
  objective.index = TRUE
)
}
\arguments{
\item{evals}{\verb{[integer(1)]} limit evals.}

\item{generations}{\verb{[integer(1)]} limit generations. Initial population does
not count.}

\item{time}{\verb{[numeric(1)]} limit evaluation time (which does not count
holdout fitting time.}

\item{fidelity}{\verb{[numeric(1)]} total fidelity evaluation to limit.}

\item{stag}{\verb{[integer(1)]} number of generations (or other measures)
without progress in hypervolume or mean objective value.}

\item{stag.index}{\verb{[character(1)]} one of \code{"generations"} (default),
\code{"evals"}, \code{"time"}, \code{"fidelity"}: What index to count \code{stag} against when
aborting after stagnation.}

\item{obj.stat}{\verb{[character(1)]} what statistic of the objective to test.
One of "min", "mean", "max". Default "mean".}

\item{objective.index}{\verb{[integer | logical]} index of objective(s) to consider. Terminates
if all the objectives listed here stagnate. \code{TRUE} for all objectives. Default \code{TRUE}.}
}
\value{
\code{function} a terminator function
}
\description{
These create functions that can be given to \code{slickEcr}'s \code{generations} argument

The stagnation terminators only count stagnation from the last time
the fidelity was changed in a way that led to population re-evaluation.
}
