% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagen.R
\name{clonetask}
\alias{clonetask}
\title{Replace Data in Task with new Data}
\usage{
clonetask(
  task,
  newdata,
  newid,
  orig.features = rep(TRUE, ncol(newdata) - length(getTaskTargetNames(task)))
)
}
\arguments{
\item{task}{\verb{[Task]} mlr \code{\link{Task}} to use.}

\item{newdata}{\verb{[data.frame]} data to replace \code{task} data with; must
include the target column with same name.}

\item{newid}{\verb{[character(1)]} ID to use for new \code{Task}.}

\item{orig.features}{\verb{[logical]} features that correspond to original task's data.}
}
\value{
\code{\link{Task}}
}
\description{
Create new task identical to the old one, but with \code{newdata} instead
of old data. This should either preserve the \code{orig.features} of the
original task, or should add new noise-features, in which case \code{orig.features}
should mark the features that correspond to the full original task.
}
\seealso{
Other Artificial Datasets: 
\code{\link{create.hypersphere.data}()},
\code{\link{create.linear.data}()},
\code{\link{create.linear.toy.data}()},
\code{\link{create.regr.task}()},
\code{\link{task.add.permuted.cols}()},
\code{\link{task.add.random.cols}()}
}
\concept{Artificial Datasets}
