% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{project}
\alias{dot}
\alias{project}
\alias{project,formula-method}
\alias{project,matrix-method}
\alias{project,numeric-method}
\alias{vlength}
\title{Projections}
\usage{
project(x, u, data = parent.env(), ...)

\S4method{project}{formula}(x, u = NULL, data = parent.frame(),
  coefficients = TRUE, ...)

\S4method{project}{numeric}(x, u = rep(1, length(x)), type = c("vector",
  "length"), ...)

\S4method{project}{matrix}(x, u, data = parent.frame())

vlength(x, ...)

dot(u, v)
}
\arguments{
\item{x}{a numeric vector (all functions) or a formula (only for \code{project}).
Left-hand sides of formulas should be a single quantity}

\item{u}{a numeric vector}

\item{v}{a numeric vector}

\item{data}{a data frame.}

\item{type}{one of \code{"length"} or \code{"vector"} determining the type of the
returned value}

\item{coefficients}{For \code{project(y ~ x)} indicates whether the projection
coeffients should be returned or the projection vector.}

\item{...}{additional arguments}
}
\value{
\code{project} returns the projection of \code{x} onto \code{u}
(or its length if \code{u} and \code{v} are numeric vectors and \code{type == "length"})

\code{vlength} returns the length of the vector
(i.e., the square root of the sum of the squares of the components)

\code{dot} returns the dot product of \code{u} and \code{v}
}
\description{
Compute projections onto the span of a vector or a model space, dot products, and
vector lengths in Euclidean space.
}
\details{
\code{project} (preferably pronounced "pro-JECT" as in "projection")
does either of two related things:
(1) Given two vectors as arguments, it will project the first onto the
second, returning the point in the subspace of the second that is as
close as possible to the first vector.  (2) Given a formula as an argument,
will work very much like \code{lm()}, constructing a model matrix from
the right-hand side of the formula and projecting the vector on the
left-hand side onto the subspace of that model matrix.

In (2), rather than
returning the projected vector, \code{project()} returns the coefficients
on each of the vectors in the model matrix.
UNLIKE \code{lm()}, the intercept vector is NOT included by default.  If
you want an intercept vector, include \code{+1} in your formula.
}
\examples{
x1 <- c(1,0,0); x2 <- c(1,2,3); y1 <- c(3,4,5); y2 <- rnorm(3)
# projection onto the 1 vector gives the mean vector
mean(y2)
project(y2, 1)
# return the length of the vector, rather than the vector itself
project(y2, 1, type='length')
project(y1 ~ x1 + x2) -> pr; pr
# recover the projected vector
cbind(x1,x2) \%*\% pr -> v; v
project( y1 ~ x1 + x2, coefficients=FALSE )
dot( y1 - v, v ) # left over should be orthogonal to projection, so this should be ~ 0
if (require(mosaicData)) {
project(width~length+sex, data=KidsFeet)
}
vlength(rep(1,4))
if (require(mosaicData)) {
m <- lm( length ~ width, data=KidsFeet )
# These should be the same
vlength( m$effects )
vlength( KidsFeet$length)
# So should these
vlength( tail(m$effects, -2) )
sqrt(sum(resid(m)^2))
}
v <- c(1,1,1); w <- c(1,2,3)
u <- v / vlength(v)  # make a unit vector
# The following are equivalent
dot( w, u )
vlength( project( w, u) )
vlength( project( w, v) )
project( w, v, type='length' )
}
\seealso{
\code{link{project}}
}

