% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_functions.R
\name{prep.life.table}
\alias{prep.life.table}
\title{Creates the input for the function life.table.}
\usage{
prep.life.table(x, dec = NA, agebeg, ageend, group = NA,
  method = "Standard", agerange = "included")
}
\arguments{
\item{x}{single dataframe containing sex age and quantity of deceased (individuals or group of individuals).}

\item{dec}{numeric vector or a column name (as character) of the count of deceased.}

\item{agebeg}{numeric vector or a column name (as character) for the beginning of an age range.}

\item{ageend}{numeric vector or a column name (as character) for the end of an age range.}

\item{group}{numeric vector or a column name (as character) of the grouping field (e.g., sex),
optional. Default setup is: \code{NA}.}

\item{method}{character string, optional. Default options is \code{Standard}, which will create age classes beginning with 1 year,
up to 4 years, followed by steps of 5 years (1,4,5,5,...) until the maximum age is reached. \code{Equal5} will create age classes with an even distribution, stepped by 5 years (5,5,...) until the maximum age is reached.}

\item{agerange}{character string, optional. Default setup is: \code{excluded}.
If the age ranges from "20 to 40" and "40 to 60", \code{excluded} will exclude the year 40 from "20 to 40",
to  prevent overlapping age classes. \code{included} is for age ranges like "20 to 39"
where the year 39 is meant to be counted.}
}
\value{
A list of input parameter needed for the function \code{life.table}.

\itemize{
  \item \bold{x} or \bold{Age}:  age interval.
  \item \bold{a}:  years within x.
  \item \bold{Dx}: number of deaths within \bold{x}.
}
}
\description{
Prepares the input for \code{life.table()}. An individual based approach is supported as well
as already pooled data (e. g. from an already existing life table). In the latter case, the user
has to specify a numerical variable (\bold{dec}) which defines the count for each age class.
If no life table exists, this function will process a dataframe including the age ranges of
individuals or groups of individuals to discrete the age classes. The age range is spread to
single years. \bold{agebeg} has to be specified for the beginning of an age range, as well
as \bold{ageend} for the end of an age range. The \bold{method} defines in which way the single years between the different age classes are split.
If the data set comprises a grouping variable (e.g., sex), this can be specified with \bold{group}.
}
\examples{
# Separate age ranges in your data set.
df <- dplyr::mutate(
  tidyr::separate(
    replace(
     magdalenenberg,
     magdalenenberg=="60-x", "60-69"
    ),
    a,
    c("from", "to")
  ),
  from = as.numeric(from),
  to = as.numeric(to)
)

# Apply prep.life.table to a data set containing the age ranges.
magda_prep <- prep.life.table(
  df,
  dec = "Dx",
  agebeg = "from",
  ageend = "to",
  method = "Equal5",
  agerange = "included"
)

# Create a life.table.
life.table(magda_prep)

}
