% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survData.R
\name{survData}
\alias{survData}
\title{Creates a dataset for survival analysis}
\usage{
survData(x)
}
\arguments{
\item{x}{a \code{data.frame} containing the following four columns:
\itemize{
\item \code{replicate}: a vector of class \code{integer} or \code{factor} for replicate
identification. A given replicate value should identify the same group of
individuals followed in time
\item \code{conc}: a vector of class \code{numeric} with tested concentrations
(positive values, may contain NAs)
\item \code{time}: a vector of class \code{integer} with time points, minimal value must be 0
\item \code{Nsurv}: a vector of class \code{integer} providing the number of
alive individuals at each time point for each concentration and each replicate
(may contain NAs)
}}
}
\value{
A dataframe of class \code{survData}.
}
\description{
This function creates a \code{survData} object from experimental data
provided as a \code{data.frame}. The resulting object
can then be used for plotting and model fitting. It can also be used
to generate \emph{individual-time} estimates.
}
\details{
Survival datasets can be under either constant or time-variable exposure profile. The
resulting object, in addition to its \code{survData} class, inherits the
class \code{survDataCstExp} or \code{survDataVarExp} respectively.

The \code{x} argument describes experimental results from a survival
toxicity test. Each line of the \code{data.frame}
corresponds to one experimental measurement, that is a number of alive
individuals at a given concentration at a given time point and in a given replicate.
 Note that either the concentration
or the number of alive individuals may be missing. The dataset is inferred
to be under constant exposure if the concentration is constant for each
replicate and systematically available. The function \code{survData} fails if
\code{x} does not meet the
expected requirements. Please run \code{\link{survDataCheck}} to ensure
\code{x} is well-formed.
}
\examples{

# (1) Load the survival dataset
data(zinc)

# (2) Create an objet of class 'survData'
dat <- survData(zinc)
class(dat)

}
\seealso{
\code{\link{survDataCheck}}
}
\keyword{transformation}
