% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shorth.R
\name{shorth}
\alias{shorth}
\title{Mean of the Shorthest Half}
\usage{
shorth(data, indices = NULL)
}
\arguments{
\item{data}{the data as a vector.}

\item{indices}{the selected indices of \code{data}, by default \code{seq_along(data)}.}
}
\value{
The mean of the data points in the shortest interval containing half of the data.
}
\description{
Calculates the mean of the data points in the shortest interval containing half of the data.
This function is ready to be used as a statistic in \code{\link[=mboot]{mboot()}} function.
}
\examples{
data <- rnorm(100)
shorth(data)
shorth(data, sample(1:100, size = 20))

# Calculating a CI for shorth using [mboot()]
data <- rnorm(100)
boot.out <- mboot(data, shorth, m = sqrt(length(data)))
basic.ci <- mboot.ci(boot.out, conf =0.95, tau = function(n) return(n^(1/3)), types = "basic")$basic

}
\references{
Andrews D.F. et al. (1972) \emph{Robust Estimates of Location} Princeton University Press, Princeton.
}
