% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_HELPERS.R
\name{desc.report}
\alias{desc.report}
\title{Descriptive statistics report}
\usage{
desc.report(target, rf, sc, sc.method, db)
}
\arguments{
\item{target}{Selected target.}

\item{rf}{Vector of a selected numeric risk factors.}

\item{sc}{Numeric vector of special case values.}

\item{sc.method}{Define how special cases will be treated, all together or in separate bins.}

\item{db}{Data frame of target and numeric risk factors.}
}
\value{
Returns a data frame with descriptive statistics for the selected risk drivers.
}
\description{
Descriptive statistics report
}
\examples{
if 	(interactive()) {
	srv$desc.stat <-  withProgress(message = "Running descriptive statistics report", 
						 value = 0, {
				desc.report(target = "qual", 
						rf = rf, 
						sc = sc, 
						sc.method = sc.method, 
						db = isolate(rv$db))
				})
	}

}
