% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_mego.R
\name{max_EI}
\alias{max_EI}
\title{max_EI: Maximization of the Constrained Expected Improvement criterion}
\usage{
max_EI(
  model,
  lower = rep(0, model@d),
  upper = rep(1, model@d),
  control = NULL,
  optimcontrol = NULL
)
}
\arguments{
\item{model}{An object of class \code{\link{mkm}}. This \code{model} must have a single
objective (\code{model@m == 1}).}

\item{lower}{Vector of lower bounds for the variables to be optimized over
(default: 0 with length = \code{model@d}),}

\item{upper}{Vector of upper bounds for the variables to be optimized over
(default: 1 with length = \code{model@d}),}

\item{control}{An optional list of control parameters, some of them passed to
the EI function. One can control:
  \describe{
   \item{\code{minimization}}{logical specifying if EI is used in minimization or in maximization
   (default: \code{TRUE})}
   \item{\code{plugin}}{optional scalar, if not provided, the minimum (or maximum) of the current
    feasible observations. If there isn't any feasible design plugin is set to \code{NA} and the
    algorithm returns the value of the probability of constraints be met.}
   \item{\code{envir}}{optional environment specifying where to assign intermediate values.
    Default: \code{NULL}.}
  }}

\item{optimcontrol}{Optional list of control parameters passed to the
\code{\link[GenSA]{GenSA}} function. Please, note that the values are
passed as the \code{control} parameter inside the \code{GenSA} function (\code{genSA(control = optimcontrol)}).}
}
\value{
A list with components: \describe{
 \item{\code{par}}{The best set of parameters found.}
 \item{\code{value}}{The value of expected hypervolume improvement at par.}
 }

Vector. The best set of parameters found.
}
\description{
Given an object of class \code{\link{mkm}} and a set of tuning parameters,
max_EI performs the maximization of the Constrained Expected Improvement
criterion and delivers the next point to be visited in an MEGO-like
procedure.
}
\examples{
# --------------------------------------------
# Branin-Hoo function (with simple constraint)
# --------------------------------------------
n <- 10
d <- 2
doe <- replicate(d,sample(0:n,n))/n
fun_cost <- DiceKriging::branin
fun_cntr <- function(x) 0.2 - prod(x)
fun <- function(x) return(cbind(fun_cost(x),fun_cntr(x)))
res <- t(apply(doe, 1, fun))
model <- mkm(doe, res, modelcontrol = list(objective = 1, lower=c(0.1,0.1)))
max_EI(model)
}
