% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moezipfR.moments.R
\name{moezipfR.moments}
\alias{moezipfR.moments}
\title{Distribution Moments.}
\usage{
moezipfR.moments(k, alpha, beta, tolerance = 10^(-4))
}
\arguments{
\item{k}{Order of the moment to compute.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > k + 1}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta > 0}).}

\item{tolerance}{Tolerance used in the calculations (default = \eqn{10^{-4}}).}
}
\value{
A positive real value corresponding to the k-th moment of the distribution.
}
\description{
Generic function to compute the k-th moment of the distribution, for any \eqn{k \geq 1}
when it exists. Note that the k-th moment exists if and only if  \eqn{\alpha > k + 1}.
When k = 1, this function returns the same value as the
\link{moezipfR.mean} function.
}
\details{
The k-th moment of the MOEZipf distribution is finite for \eqn{\alpha} values strictly greater than \eqn{k + 1}.
For a random variable Y that follows a MOEZipf distribution with parameters \eqn{\alpha} and \eqn{\beta},
the k-th moment is computed as:

\deqn{E(Y^k) = \sum_{x = 1} ^\infty \frac{\beta \zeta(\alpha) x^{-\alpha + k}}{[\zeta(\alpha) - \bar{\beta}\zeta(\alpha, x)][\zeta(\alpha) - \bar{\beta}\zeta(\alpha, x + 1)]}, \alpha \geq k + 1, \beta > 0}

The k-th moment is computed by calculating the partial sums of the serie. When two
consecutive partial sums differs less than the \code{tolerance} value, the process
stops and the partial sum is returned.
}
\examples{
moezipfR.moments(3, 4.5, 1.3)
moezipfR.moments(3, 4.5, 1.3,  1*10^(-3))
}

