% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbmk.R
\name{pbmk}
\alias{pbmk}
\title{Decorrelated bootstrapped-based Mann-Kendall Test}
\usage{
pbmk(x, ci=0.95, nsim=1000, pw="Hamed")
}
\arguments{
\item{x}{- Time series data vector}

\item{ci}{- Confidence Interval}

\item{nsim}{- Number of Simulations}

\item{pw}{-  Unbiased pre-whitening suggested by Hamed 2009}
}
\value{
Z  - Original Mann- Kendall Z-statistic

Slp  - Original sen's slope

S.orig  - Original Mann-Kendall 'S'- statistic

Tau  - Original Mann-Kendall's Tau

Zpw  - Bias Corrected Prewhitened  Mann- Kendall Z-statistic

Slppw  - Bias Corrected Prewhitened  sen's slope

Spw  - Bias Corrected Prewhitened  Mann-Kendall 'S'- statistic

Taupw  - Bias Corrected Prewhitened  Mann-Kendall's Tau

pval - Bootstrapped P-Value
}
\description{
Lancombe et al. (2012) suggest the use of effective prewhitening (Hamed, 2009) to initially decorrelate the data after which the bootstrap based Mann-Kendall test is applied (Yue and Pilon, 2004).
}
\details{
The block bootstrap is used along with the non-parametric Mann-Kendall trend test.  A test statistic falling in the tails of the simulated empirical distribution, the results is likely significant.
}
\examples{
x<-c(Nile[1:10])
pbmk(x)

}
\references{
Hamed, K. H. (2009). Enhancing the effectiveness of prewhitening in trend analysis of hydrologic data. Journal of Hydrology, 368: 143-155.

Kendall, M. (1975). Multivariate analysis. Charles Griffin. Londres. 0-85264-234-2.

Kundzewicz, Z. W. and Robson, A. J. (2004). Change detection in hydrological records - a review of the methodology. Hydrological Sciences Journal, 49(1): 7-19.

Lancombe, G., McCartney, M., and Forkuor, G. (2012). Drying climate in Ghana over the period 1960-2005: evidence from the resampling-based Mann-Kendall test at local and regional levels. Hydrological Sciences Journal, 57(8): 1594-1609. doi:10.1080/02626667.2012.728291

Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3), 245?259. <doi:10.1017/CBO9781107415324.004>

van Giersbergen, N. P. A. (2005). On the effect of deterministic terms on the bias in stable AR models. Economic Letters, 89: 75-82.

Yue, S. and Pilon, P. (2004). A comparison of the power of the t test, Mann-Kendall and bootstrap tests for trend detection, Hydrological Sciences Journal, 49(1): 21-37.
}
