% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIMCD.R
\name{GIMCD}
\alias{GIMCD}
\title{Gaussian imputation followed by MCD}
\usage{
GIMCD(data, alpha = 0.05, seedem = 23456789, seedmcd)
}
\arguments{
\item{data}{a data frame or matrix with the data.}

\item{alpha}{a threshold value for the cut-off for the outlier
Mahalanobis distances.}

\item{seedem}{random number generator seed for EM algorithm}

\item{seedmcd}{random number generator seed for MCD algorithm,
if \code{seedmcd} is missing, an internal seed will be used.}
}
\value{
Result is stored in a global list GIMCD.r:
\describe{
  \item{\code{center}}{robust center}
  \item{\code{scatter}}{robust covariance}
  \item{\code{alpha}}{quantile for cut-off value}
  \item{\code{computation.time}}{elapsed computation time}
  \item{\code{outind}}{logical vector of outlier indicators}
  \item{\code{dist}}{Mahalanobis distances}
}
}
\description{
Gaussian imputation uses the classical non-robust mean and covariance
estimator and then imputes predictions under the multivariate normal model.
Outliers may be created by this procedure. Then a high-breakdown robust
estimate of the location and scatter with the Minimum Covariance Determinant
algorithm is obtained and finally outliers are determined based on Mahalanobis
distances based on the robust location and scatter.
}
\details{
Normal imputation from package \code{norm} and MCD from package \code{MASS}.
Note that currently MCD does not accept weights.
}
\examples{
data(bushfirem)
det.res <- GIMCD(bushfirem, alpha = 0.1)
print(det.res$center)
PlotMD(det.res$dist, ncol(bushfirem))
}
\references{
Béguin, C. and Hulliger, B. (2008), The BACON-EEM Algorithm
for Multivariate Outlier Detection, in Incomplete Survey Data, Survey
Methodology, Vol. 34, No. 1, pp. 91-103.
}
\seealso{
\code{\link[MASS]{cov.rob}}
}
\author{
Beat Hulliger
}
