% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-seasonal_decomp.R
\name{seasonal_decomp}
\alias{seasonal_decomp}
\title{General Interface for Seasonal Decomposition Regression Models}
\usage{
seasonal_decomp(
  mode = "regression",
  seasonal_period_1 = NULL,
  seasonal_period_2 = NULL,
  seasonal_period_3 = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{seasonal_period_1}{(required) The primary seasonal frequency.
Uses \code{"auto"} by default.
A character phrase of "auto" or time-based phrase of "2 weeks"
can be used if a date or date-time variable is provided.
See Fit Details below.}

\item{seasonal_period_2}{(optional) A second seasonal frequency.
Is \code{NULL} by default.
A character phrase of "auto" or time-based phrase of "2 weeks"
can be used if a date or date-time variable is provided.
See Fit Details below.}

\item{seasonal_period_3}{(optional) A third seasonal frequency.
Is \code{NULL} by default.
A character phrase of "auto" or time-based phrase of "2 weeks"
can be used if a date or date-time variable is provided.
See Fit Details below.}
}
\description{
\code{seasonal_decomp()} is a way to generate a \emph{specification} of an
Seasonal Decomposition model
before fitting and allows the model to be created using
different packages. Currently the only package is \code{forecast}.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{seasonal_decomp()}, the
mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item "stlm_ets" (default) - Connects to \code{forecast::stlm()}, \code{method = "ets"}
\item "stlm_arima" (default) - Connects to \code{forecast::stlm()}, \code{method = "arima"}
}
}
\section{Engine Details}{


The standardized parameter names in \code{modeltime} can be mapped to their original
names in each engine:\tabular{ll}{
   modeltime \tab forecast::stlm \cr
   seasonal_period_1, seasonal_period_2, seasonal_period_3 \tab msts(seasonal.periods) \cr
}


Other options can be set using \code{set_engine()}.

The engines use \code{forecast::stlm()}.

Function Parameters:\preformatted{## function (y, s.window = 13, robust = FALSE, method = c("ets", "arima"), 
##     modelfunction = NULL, model = NULL, etsmodel = "ZZN", lambda = NULL, 
##     biasadj = FALSE, xreg = NULL, allow.multiplicative.trend = FALSE, x = y, 
##     ...)
}

\strong{stlm_ets (default engine)}
\itemize{
\item \strong{Method:} Uses \code{method = "ets"}, which by default is auto-ETS.
\item \strong{Xregs:} Cannot accept Exogenous Regressors (xregs). Xregs are ignored.
}

\strong{stlm_arima}
\itemize{
\item \strong{Method:} Uses \code{method = "arima"}, which by default is auto-ARIMA.
\item \strong{Xregs:} Can accept Exogenous Regressors (xregs).
}
}

\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\emph{Seasonal Period Specification}

The period can be non-seasonal (\verb{seasonal_period = 1 or "none"}) or
yearly seasonal (e.g. For monthly time stamps, \code{seasonal_period = 12}, \code{seasonal_period = "12 months"}, or \code{seasonal_period = "yearly"}).
There are 3 ways to specify:
\enumerate{
\item \code{seasonal_period = "auto"}: A seasonal period is selected based on the periodicity of the data (e.g. 12 if monthly)
\item \code{seasonal_period = 12}: A numeric frequency. For example, 12 is common for monthly data
\item \code{seasonal_period = "1 year"}: A time-based phrase. For example, "1 year" would convert to 12 for monthly data.
}

\strong{Univariate (No xregs, Exogenous Regressors):}

For univariate analysis, you must include a date or date-time feature. Simply use:
\itemize{
\item Formula Interface (recommended): \code{fit(y ~ date)} will ignore xreg's.
\item XY Interface: \code{fit_xy(x = data[,"date"], y = data$y)} will ignore xreg's.
}

\strong{Multivariate (xregs, Exogenous Regressors)}
\itemize{
\item The \code{stlm_ets} engine \emph{cannot} accept Xregs.
\item The \code{stlm_arima} engine can accept Xregs
}

The \code{xreg} parameter is populated using the \code{fit()} or \code{fit_xy()} function:
\itemize{
\item Only \code{factor}, \verb{ordered factor}, and \code{numeric} data will be used as xregs.
\item Date and Date-time variables are not used as xregs
\item \code{character} data should be converted to factor.
}

\emph{Xreg Example:} Suppose you have 3 features:
\enumerate{
\item \code{y} (target)
\item \code{date} (time stamp),
\item \code{month.lbl} (labeled month as a ordered factor).
}

The \code{month.lbl} is an exogenous regressor that can be passed to the \code{seasonal_decomp()} using
\code{fit()}:
\itemize{
\item \code{fit(y ~ date + month.lbl)} will pass \code{month.lbl} on as an exogenous regressor.
\item \code{fit_xy(data[,c("date", "month.lbl")], y = data$y)} will pass x, where x is a data frame containing \code{month.lbl}
and the \code{date} feature. Only \code{month.lbl} will be used as an exogenous regressor.
}

Note that date or date-time class values are excluded from \code{xreg}.
}

\examples{
library(dplyr)
library(parsnip)
library(rsample)
library(timetk)
library(modeltime)

# Data
taylor_30_min

# Split Data 80/20
splits <- initial_time_split(taylor_30_min, prop = 0.8)

# ---- STLM ETS ----

# Model Spec
model_spec <- seasonal_decomp() \%>\%
    set_engine("stlm_ets")

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date, data = training(splits))
model_fit


# ---- STLM ARIMA ----

# Model Spec
model_spec <- seasonal_decomp() \%>\%
    set_engine("stlm_arima")

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date, data = training(splits))
model_fit

}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
