% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_resample_accuracy.R
\name{modeltime_resample_accuracy}
\alias{modeltime_resample_accuracy}
\title{Calculate Accuracy Metrics from Modeltime Resamples}
\usage{
modeltime_resample_accuracy(
  object,
  summary_fns = mean,
  metric_set = default_forecast_accuracy_metric_set(),
  ...
)
}
\arguments{
\item{object}{a Modeltime Table with a column '.resample_results' (the output of \code{\link[=modeltime_fit_resamples]{modeltime_fit_resamples()}})}

\item{summary_fns}{One or more functions to analyze resamples. The default is \code{mean()}.
Possible values are:
\itemize{
\item NULL, to returns the resamples untransformed.
\item A function, e.g. mean.
\item A purrr-style lambda, e.g. ~ mean(.x, na.rm = TRUE)
\item A list of functions/lambdas, e.g. list(mean = mean, sd = sd)
}}

\item{metric_set}{A \code{yardstick::metric_set()} that is used to summarize one or more
forecast accuracy (regression) metrics.}

\item{...}{Additional arguments passed to the function calls in \code{summary_fns}.}
}
\description{
This is a wrapper for \code{yardstick} that simplifies time
series regression accuracy metric calculations from
a Modeltime Table that has been resampled and fitted using
\code{\link[=modeltime_fit_resamples]{modeltime_fit_resamples()}}.
}
\details{
#' \strong{Default Accuracy Metrics}

The following accuracy metrics are included by default via \code{\link[modeltime:metric_sets]{modeltime::default_forecast_accuracy_metric_set()}}:
\itemize{
\item MAE - Mean absolute error, \code{\link[yardstick:mae]{yardstick::mae()}}
\item MAPE - Mean absolute percentage error, \code{\link[yardstick:mape]{yardstick::mape()}}
\item MASE  - Mean absolute scaled error, \code{\link[yardstick:mase]{yardstick::mase()}}
\item SMAPE - Symmetric mean absolute percentage error, \code{\link[yardstick:smape]{yardstick::smape()}}
\item RMSE  - Root mean squared error, \code{\link[yardstick:rmse]{yardstick::rmse()}}
\item RSQ   - R-squared, \code{\link[yardstick:rsq]{yardstick::rsq()}}
}

\strong{Summary Functions}

By default, \code{modeltime_resample_accuracy()} returns
the \emph{average} accuracy metrics for each resample prediction.

The user can change this default behavior using \code{summary_fns}.
Simply pass one or more Summary Functions. Internally, the functions are passed to
\code{dplyr::across(.fns)}, which applies the summary functions.

\strong{Returning Unsummarized Results}

You can pass \code{summary_fns = NULL} to return unsummarized results by \code{.resample_id}.

\strong{Professional Tables (Interactive & Static)}

Use \code{\link[modeltime:table_modeltime_accuracy]{modeltime::table_modeltime_accuracy()}} to format the results for reporting in
\code{reactable} (interactive) or \code{gt} (static) formats, which are perfect for
Shiny Apps (interactive) and PDF Reports (static).
}
\examples{
library(modeltime)

# Mean (Default)
m750_training_resamples_fitted \%>\%
    modeltime_resample_accuracy() \%>\%
    table_modeltime_accuracy(.interactive = FALSE)

# Mean and Standard Deviation
m750_training_resamples_fitted \%>\%
    modeltime_resample_accuracy(
        summary_fns = list(mean = mean, sd = sd)
    ) \%>\%
    table_modeltime_accuracy(.interactive = FALSE)

# When summary_fns = NULL, returns the unsummarized resample results
m750_training_resamples_fitted \%>\%
    modeltime_resample_accuracy(
        summary_fns = NULL
    )

}
